/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import de.dagere.nodeDiffDetector.config.FolderConfig;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.typeFinding.FQNDeterminer;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import de.dagere.peass.testtransformation.ParseUtil;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NonIncludedByRule {
    private static final Logger LOG = LogManager.getLogger(NonIncludedByRule.class);

    public static boolean isTestIncluded(TestCase test, JUnitTestTransformer transformer, ModuleClassMapping mapping) {
        ExecutionConfig executionConfig = transformer.getConfig().getExecutionConfig();
        CompilationUnit unit = NonIncludedByRule.getUnit(test, transformer, executionConfig);
        if (unit == null) {
            LOG.info("Did not find compilation unit for {}, assuming test is not existing but was included before", (Object)test);
            return true;
        }
        IncludeExcludeInfo testInfo = NonIncludedByRule.getIncludeExcludeInfo(executionConfig, unit);
        IncludeExcludeInfo parentInfo = NonIncludedByRule.getParentInfo(transformer, executionConfig, unit, mapping);
        return testInfo.isSelected() && !parentInfo.isExcluded() || parentInfo.isIncluded() && !parentInfo.isExcluded();
    }

    private static IncludeExcludeInfo getParentInfo(JUnitTestTransformer transformer, ExecutionConfig executionConfig, CompilationUnit unit, ModuleClassMapping mapping) {
        boolean anyParentExcluded = false;
        boolean anyParentIncluded = false;
        TestClazzCall parentTest = NonIncludedByRule.getParentTest(unit, mapping);
        while (parentTest != null) {
            CompilationUnit parentUnit = NonIncludedByRule.getUnit((TestCase)parentTest, transformer, executionConfig);
            if (parentUnit == null) {
                LOG.warn("Did not find {}; ignoring parent class for includeByRule-checking", (Object)parentTest);
                break;
            }
            IncludeExcludeInfo parentInfo = NonIncludedByRule.getIncludeExcludeInfo(executionConfig, parentUnit);
            if (parentInfo.isExcluded()) {
                anyParentExcluded = true;
            }
            if (parentInfo.isIncluded()) {
                anyParentIncluded = true;
            }
            parentTest = NonIncludedByRule.getParentTest(parentUnit, mapping);
        }
        IncludeExcludeInfo parentInfo = new IncludeExcludeInfo(anyParentIncluded, anyParentExcluded);
        return parentInfo;
    }

    private static TestClazzCall getParentTest(CompilationUnit unit, ModuleClassMapping mapping) {
        for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
            String extendType;
            String fqn;
            String module;
            if (clazz.getExtendedTypes().size() != 1 || (module = mapping.getModuleOfClass(fqn = FQNDeterminer.getParameterFQN((CompilationUnit)unit, (String)(extendType = clazz.getExtendedTypes(0).getNameAsString())))) == null) continue;
            TestClazzCall parentTest = new TestClazzCall(fqn, module);
            return parentTest;
        }
        return null;
    }

    private static IncludeExcludeInfo getIncludeExcludeInfo(ExecutionConfig executionConfig, CompilationUnit unit) {
        boolean includedByRule = NonIncludedByRule.isIncluded(executionConfig, unit);
        boolean excludeByRule = NonIncludedByRule.isExcluded(executionConfig, unit);
        return new IncludeExcludeInfo(includedByRule, excludeByRule);
    }

    private static CompilationUnit getUnit(TestCase test, JUnitTestTransformer transformer, ExecutionConfig executionConfig) {
        TypeFileFinder finder = new TypeFileFinder((FolderConfig)executionConfig);
        File clazzFile = finder.getClazzFile(transformer.getProjectFolder(), test);
        CompilationUnit unit = transformer.getLoadedFiles().get(clazzFile);
        return unit;
    }

    private static boolean isExcluded(ExecutionConfig executionConfig, CompilationUnit unit) {
        boolean excludeByRule = false;
        if (executionConfig.getExcludeByRule().size() != 0) {
            for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
                for (FieldDeclaration declaration : clazz.getFields()) {
                    String fieldType = declaration.getElementType().toString();
                    if (!executionConfig.getExcludeByRule().contains(fieldType)) continue;
                    excludeByRule = true;
                }
            }
        }
        return excludeByRule;
    }

    private static boolean isIncluded(ExecutionConfig executionConfig, CompilationUnit unit) {
        boolean includedByRule;
        boolean bl = includedByRule = executionConfig.getIncludeByRule().size() == 0;
        if (!includedByRule) {
            for (ClassOrInterfaceDeclaration clazz : ParseUtil.getClasses(unit)) {
                for (FieldDeclaration declaration : clazz.getFields()) {
                    String fieldType = declaration.getElementType().toString();
                    if (!executionConfig.getIncludeByRule().contains(fieldType)) continue;
                    includedByRule = true;
                }
            }
        }
        return includedByRule;
    }

    public static void removeNotIncluded(TestSet tests, TestTransformer testTransformer, ModuleClassMapping mapping) {
        if (testTransformer.getConfig().getExecutionConfig().getIncludeByRule().size() > 0 && testTransformer instanceof JUnitTestTransformer) {
            JUnitTestTransformer junitTestTransformer = (JUnitTestTransformer)testTransformer;
            Iterator<Map.Entry<TestClazzCall, Set<String>>> testcaseIterator = tests.getTestcases().entrySet().iterator();
            while (testcaseIterator.hasNext()) {
                Map.Entry<TestClazzCall, Set<String>> testcase = testcaseIterator.next();
                if (NonIncludedByRule.isTestIncluded((TestCase)testcase.getKey(), junitTestTransformer, mapping)) continue;
                testcaseIterator.remove();
            }
        }
    }

    private static class IncludeExcludeInfo {
        private final boolean included;
        private final boolean excluded;

        public IncludeExcludeInfo(boolean included, boolean excluded) {
            this.included = included;
            this.excluded = excluded;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public boolean isIncluded() {
            return this.included;
        }

        public boolean isSelected() {
            return this.included && !this.excluded;
        }
    }
}

