/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.analysis.data.TestSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NonIncludedTestRemover {
    private static final Logger LOG = LogManager.getLogger(NonIncludedTestRemover.class);

    public static void removeNotIncluded(TestSet tests, ExecutionConfig executionConfig) {
        if (executionConfig.getIncludes().size() > 0) {
            Iterator<Map.Entry<TestClazzCall, Set<String>>> testcaseIterator = tests.getTestcases().entrySet().iterator();
            while (testcaseIterator.hasNext()) {
                Map.Entry<TestClazzCall, Set<String>> testcase = testcaseIterator.next();
                if (!testcase.getValue().isEmpty()) {
                    NonIncludedTestRemover.removeTestsWithMethod(executionConfig, testcaseIterator, testcase);
                    continue;
                }
                NonIncludedTestRemover.removeTestsWithoutMethod(executionConfig, testcaseIterator, testcase);
            }
        }
    }

    private static void removeTestsWithoutMethod(ExecutionConfig executionConfig, Iterator<Map.Entry<TestClazzCall, Set<String>>> testcaseIterator, Map.Entry<TestClazzCall, Set<String>> testcase) {
        TestClazzCall test = testcase.getKey();
        if (!NonIncludedTestRemover.isTestIncluded((TestCase)test, executionConfig)) {
            testcaseIterator.remove();
        }
    }

    private static void removeTestsWithMethod(ExecutionConfig executionConfig, Iterator<Map.Entry<TestClazzCall, Set<String>>> testcaseIterator, Map.Entry<TestClazzCall, Set<String>> testcase) {
        Iterator<String> methodIterator = testcase.getValue().iterator();
        while (methodIterator.hasNext()) {
            String methodAndParams = methodIterator.next();
            TestMethodCall test = NonIncludedTestRemover.getTestMethodCall(testcase, methodAndParams);
            if (NonIncludedTestRemover.isTestIncluded((TestCase)test, executionConfig)) continue;
            methodIterator.remove();
        }
        if (testcase.getValue().size() == 0) {
            testcaseIterator.remove();
        }
    }

    private static TestMethodCall getTestMethodCall(Map.Entry<TestClazzCall, Set<String>> testcase, String methodAndParams) {
        String params;
        String method;
        if (methodAndParams.contains("(")) {
            method = methodAndParams.substring(0, methodAndParams.indexOf("("));
            params = methodAndParams.substring(methodAndParams.indexOf("(") + 1, methodAndParams.length() - 1);
        } else {
            method = methodAndParams;
            params = "";
        }
        TestMethodCall test = new TestMethodCall(testcase.getKey().getClazz(), method, testcase.getKey().getModule(), params);
        return test;
    }

    public static void removeNotIncluded(Set<? extends TestCase> tests, ExecutionConfig executionConfig) {
        if (executionConfig.getIncludes().size() > 0 || executionConfig.getExcludes().size() > 0) {
            Iterator<? extends TestCase> it = tests.iterator();
            while (it.hasNext()) {
                TestCase test = it.next();
                boolean isIncluded = NonIncludedTestRemover.isTestIncluded(test, executionConfig);
                if (isIncluded) continue;
                LOG.info("Excluding non-included test {}", (Object)test);
                it.remove();
            }
        }
    }

    public static void removeNotIncludedMethods(Set<TestMethodCall> tests, ExecutionConfig executionConfig) {
        if (executionConfig.getIncludes().size() > 0 || executionConfig.getExcludes().size() > 0) {
            Iterator<TestMethodCall> it = tests.iterator();
            while (it.hasNext()) {
                TestMethodCall test = it.next();
                boolean isIncluded = NonIncludedTestRemover.isTestIncluded((TestCase)test, executionConfig);
                if (isIncluded) continue;
                LOG.info("Excluding non-included test {}", (Object)test);
                it.remove();
            }
        }
    }

    public static boolean isTestClassIncluded(TestClazzCall test, ExecutionConfig config) {
        boolean isIncluded;
        List<String> includes = config.getIncludes();
        if (includes.size() != 0) {
            isIncluded = false;
            for (String include : includes) {
                boolean match;
                if (include.contains("#")) {
                    String includeWithoutHash = include.substring(0, include.indexOf(35));
                    match = NonIncludedTestRemover.testMatch((TestCase)test, includeWithoutHash);
                } else {
                    match = NonIncludedTestRemover.testMatch((TestCase)test, include);
                }
                if (!match) continue;
                isIncluded = true;
                break;
            }
        } else {
            isIncluded = true;
        }
        return isIncluded;
    }

    public static boolean isTestIncluded(TestCase test, ExecutionConfig config) {
        boolean match;
        boolean isIncluded;
        List<String> includes = config.getIncludes();
        List<String> excludes = config.getExcludes();
        if (includes.size() != 0) {
            isIncluded = false;
            for (String include : includes) {
                match = NonIncludedTestRemover.testMatch(test, include);
                if (!match) continue;
                isIncluded = true;
                break;
            }
        } else {
            isIncluded = true;
        }
        if (excludes.size() > 0 && isIncluded) {
            for (String exclude : excludes) {
                match = NonIncludedTestRemover.testMatch(test, exclude);
                if (!match) continue;
                isIncluded = false;
            }
        }
        return isIncluded;
    }

    private static boolean testMatch(TestCase test, String pattern) {
        boolean match;
        if (pattern.contains("\u00a7")) {
            String mergedName = test.getModule() + "\u00a7" + test.getExecutable();
            match = FilenameUtils.wildcardMatch((String)mergedName, (String)pattern);
            LOG.trace("Testing {} {} {}", (Object)mergedName, (Object)pattern, (Object)match);
        } else {
            match = FilenameUtils.wildcardMatch((String)test.getExecutable(), (String)pattern);
            LOG.trace("Testing {} {} {}", (Object)test.getExecutable(), (Object)pattern, (Object)match);
        }
        return match;
    }
}

