/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.dagere.nodeDiffDetector.config.FolderConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ExecutionConfig
implements FolderConfig,
Serializable {
    public static final String CLASSPATH_SEPARATOR = ":";
    public static final String DEFAULT_TEST_TRANSFORMER = "de.dagere.peass.testtransformation.JUnitTestTransformer";
    public static final String DEFAULT_TEST_EXECUTOR = "default";
    public static final String SRC_JAVA = "src/java";
    public static final String SRC_MAIN_JAVA = "src/main/java";
    public static final String SRC_TEST_JAVA = "src/test/java";
    public static final String SRC_TEST = "src/test";
    public static final String SRC_ANDROID_TEST_JAVA = "src/androidTest/java/";
    private static final long serialVersionUID = -6642358125854337047L;
    private long timeout = 300000L;
    private String cleanGoal;
    private String testGoal;
    private List<String> executableCheckGoals = new LinkedList<String>();
    private List<String> includes = new LinkedList<String>();
    private List<String> excludes = new LinkedList<String>();
    private List<String> includeByRule = new LinkedList<String>();
    private List<String> excludeByRule = new LinkedList<String>();
    private List<String> forbiddenMethods = new LinkedList<String>();
    protected String startcommit;
    protected String endcommit;
    private boolean linearizeHistory;
    private String pl;
    private boolean redirectSubprocessOutputToFile = true;
    private boolean useTieredCompilation = false;
    private boolean removeSnapshots = false;
    private boolean useAlternativeBuildfile = false;
    private boolean excludeLog4jSlf4jImpl = false;
    private boolean excludeLog4jToSlf4j = false;
    private boolean executeBeforeClassInMeasurement = false;
    private boolean clearMockitoCaches = false;
    private boolean onlyMeasureWorkload = false;
    private boolean showStart = false;
    private boolean redirectToNull = true;
    private boolean createDetailDebugFiles = true;
    private boolean printCompilation = false;
    private String testTransformer = "de.dagere.peass.testtransformation.JUnitTestTransformer";
    private String testExecutor = "default";
    private String gitCryptKey;
    private boolean useAnbox = false;
    private String androidCompileSdkVersion;
    private String androidMinSdkVersion;
    private String androidTargetSdkVersion;
    private String androidManifest;
    private List<String> androidGradleTasks = new LinkedList<String>();
    private String androidGradleVersion;
    private String androidTestPackageName;
    private String goalCompilerVersion = null;
    private String xmx = null;
    private List<String> increaseVariableValues = new LinkedList<String>();
    private String properties;
    private List<String> clazzFolders = new LinkedList<String>();
    private List<String> testClazzFolders;

    public ExecutionConfig() {
        this.clazzFolders.add(SRC_MAIN_JAVA);
        this.clazzFolders.add(SRC_JAVA);
        this.testClazzFolders = new LinkedList<String>();
        this.testClazzFolders.add(SRC_TEST_JAVA);
        this.testClazzFolders.add(SRC_TEST);
        this.testClazzFolders.add(SRC_ANDROID_TEST_JAVA);
        this.testGoal = null;
    }

    public ExecutionConfig(ExecutionConfig other) {
        this.clazzFolders.add(SRC_MAIN_JAVA);
        this.clazzFolders.add(SRC_JAVA);
        this.testClazzFolders = new LinkedList<String>();
        this.testClazzFolders.add(SRC_TEST_JAVA);
        this.testClazzFolders.add(SRC_TEST);
        this.testClazzFolders.add(SRC_ANDROID_TEST_JAVA);
        this.timeout = other.getTimeout();
        this.testGoal = other.getTestGoal();
        this.cleanGoal = other.getCleanGoal();
        this.includes = other.getIncludes();
        this.excludes = other.getExcludes();
        this.includeByRule = other.getIncludeByRule();
        this.excludeByRule = other.getExcludeByRule();
        this.forbiddenMethods = other.getForbiddenMethods();
        this.startcommit = other.getStartcommit();
        this.endcommit = other.getEndcommit();
        this.linearizeHistory = other.linearizeHistory;
        this.redirectSubprocessOutputToFile = other.isRedirectSubprocessOutputToFile();
        this.removeSnapshots = other.removeSnapshots;
        this.useAlternativeBuildfile = other.useAlternativeBuildfile;
        this.excludeLog4jSlf4jImpl = other.excludeLog4jSlf4jImpl;
        this.excludeLog4jToSlf4j = other.excludeLog4jToSlf4j;
        this.testTransformer = other.getTestTransformer();
        this.testExecutor = other.getTestExecutor();
        this.gitCryptKey = other.getGitCryptKey();
        this.useTieredCompilation = other.isUseTieredCompilation();
        this.pl = other.getPl();
        this.executeBeforeClassInMeasurement = other.executeBeforeClassInMeasurement;
        this.clearMockitoCaches = other.clearMockitoCaches;
        this.onlyMeasureWorkload = other.onlyMeasureWorkload;
        this.showStart = other.showStart;
        this.redirectToNull = other.redirectToNull;
        this.clazzFolders = other.clazzFolders;
        this.testClazzFolders = other.testClazzFolders;
        this.useAnbox = other.useAnbox;
        this.androidCompileSdkVersion = other.androidCompileSdkVersion;
        this.androidMinSdkVersion = other.androidMinSdkVersion;
        this.androidTargetSdkVersion = other.androidTargetSdkVersion;
        this.androidManifest = other.androidManifest;
        this.androidGradleTasks = other.androidGradleTasks;
        this.androidGradleVersion = other.androidGradleVersion;
        this.androidTestPackageName = other.androidTestPackageName;
        this.xmx = other.xmx;
        this.increaseVariableValues = other.getIncreaseVariableValues();
    }

    public ExecutionConfig(long timeoutInMinutes) {
        this.clazzFolders.add(SRC_MAIN_JAVA);
        this.clazzFolders.add(SRC_JAVA);
        this.testClazzFolders = new LinkedList<String>();
        this.testClazzFolders.add(SRC_TEST_JAVA);
        this.testClazzFolders.add(SRC_TEST);
        this.testClazzFolders.add(SRC_ANDROID_TEST_JAVA);
        if (timeoutInMinutes <= 0L) {
            throw new RuntimeException("Illegal timeout: " + timeoutInMinutes);
        }
        this.includes = new LinkedList<String>();
        this.excludes = new LinkedList<String>();
        this.testGoal = null;
        this.timeout = timeoutInMinutes * 60L * 1000L;
    }

    public ExecutionConfig(@JsonProperty(value="includes") List<String> includes, @JsonProperty(value="testGoal") String testGoal) {
        this.clazzFolders.add(SRC_MAIN_JAVA);
        this.clazzFolders.add(SRC_JAVA);
        this.testClazzFolders = new LinkedList<String>();
        this.testClazzFolders.add(SRC_TEST_JAVA);
        this.testClazzFolders.add(SRC_TEST);
        this.testClazzFolders.add(SRC_ANDROID_TEST_JAVA);
        this.includes = includes;
        this.excludes = new LinkedList<String>();
        this.testGoal = testGoal;
        this.timeout = 300000L;
    }

    public static List<String> buildFolderList(String folderList) {
        String[] classpathElements;
        ArrayList<String> clazzFolders = new ArrayList<String>();
        for (String clazzFolder : classpathElements = folderList.trim().split(CLASSPATH_SEPARATOR)) {
            clazzFolders.add(clazzFolder);
        }
        return clazzFolders;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCleanGoal() {
        return this.cleanGoal;
    }

    public void setCleanGoal(String cleanGoal) {
        this.cleanGoal = cleanGoal;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTestGoal() {
        return this.testGoal;
    }

    public void setTestGoal(String testGoal) {
        this.testGoal = testGoal;
    }

    public List<String> getExecutableCheckGoals() {
        return this.executableCheckGoals;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public void setExecutableCheckGoals(List<String> executableCheckGoals) {
        this.executableCheckGoals = executableCheckGoals;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getIncludeByRule() {
        return this.includeByRule;
    }

    public void setIncludeByRule(List<String> includeByRule) {
        this.includeByRule = includeByRule;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getExcludeByRule() {
        return this.excludeByRule;
    }

    public void setExcludeByRule(List<String> excludeByRule) {
        this.excludeByRule = excludeByRule;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getForbiddenMethods() {
        return this.forbiddenMethods;
    }

    public void setForbiddenMethods(List<String> forbiddenMethods) {
        this.forbiddenMethods = forbiddenMethods;
    }

    @JsonIgnore
    public long getTimeoutInSeconds() {
        return this.timeout / 1000L;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartcommit() {
        return this.startcommit;
    }

    public void setStartcommit(String startCommit) {
        this.startcommit = startCommit;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndcommit() {
        return this.endcommit;
    }

    public void setEndcommit(String endCommit) {
        this.endcommit = endCommit;
    }

    public void setLinearizeHistory(boolean linearizeHistory) {
        this.linearizeHistory = linearizeHistory;
    }

    public boolean isLinearizeHistory() {
        return this.linearizeHistory;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPl() {
        return this.pl;
    }

    public void setPl(String pl) {
        this.pl = pl;
    }

    public boolean isRedirectSubprocessOutputToFile() {
        return this.redirectSubprocessOutputToFile;
    }

    public void setRedirectSubprocessOutputToFile(boolean redirectSubprocessOutputToFile) {
        this.redirectSubprocessOutputToFile = redirectSubprocessOutputToFile;
    }

    public boolean isUseTieredCompilation() {
        return this.useTieredCompilation;
    }

    public void setUseTieredCompilation(boolean useTieredCompilation) {
        this.useTieredCompilation = useTieredCompilation;
    }

    public void setRemoveSnapshots(boolean removeSnapshots) {
        this.removeSnapshots = removeSnapshots;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    public boolean isUseAlternativeBuildfile() {
        return this.useAlternativeBuildfile;
    }

    public void setUseAlternativeBuildfile(boolean useAlternativeBuildfile) {
        this.useAlternativeBuildfile = useAlternativeBuildfile;
    }

    public boolean isExcludeLog4jSlf4jImpl() {
        return this.excludeLog4jSlf4jImpl;
    }

    public void setExcludeLog4jSlf4jImpl(boolean excludeLog4jSlf4jImpl) {
        this.excludeLog4jSlf4jImpl = excludeLog4jSlf4jImpl;
    }

    public boolean isExcludeLog4jToSlf4j() {
        return this.excludeLog4jToSlf4j;
    }

    public void setExcludeLog4jToSlf4j(boolean excludeLog4jToSlf4j) {
        this.excludeLog4jToSlf4j = excludeLog4jToSlf4j;
    }

    public boolean isExecuteBeforeClassInMeasurement() {
        return this.executeBeforeClassInMeasurement;
    }

    public void setExecuteBeforeClassInMeasurement(boolean executeBeforeClassInMeasurement) {
        this.executeBeforeClassInMeasurement = executeBeforeClassInMeasurement;
    }

    public boolean isClearMockitoCaches() {
        return this.clearMockitoCaches;
    }

    public void setClearMockitoCaches(boolean clearMockitoCaches) {
        this.clearMockitoCaches = clearMockitoCaches;
    }

    public boolean isOnlyMeasureWorkload() {
        return this.onlyMeasureWorkload;
    }

    public void setOnlyMeasureWorkload(boolean onlyMeasureWorkload) {
        this.onlyMeasureWorkload = onlyMeasureWorkload;
    }

    public boolean isShowStart() {
        return this.showStart;
    }

    public void setShowStart(boolean showStart) {
        this.showStart = showStart;
    }

    public boolean isRedirectToNull() {
        return this.redirectToNull;
    }

    public void setRedirectToNull(boolean redirectToNull) {
        this.redirectToNull = redirectToNull;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=TestTransformerFilter.class)
    public String getTestTransformer() {
        return this.testTransformer;
    }

    public void setTestTransformer(String testTransformer) {
        this.testTransformer = testTransformer;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=TestExecutorFilter.class)
    public String getTestExecutor() {
        return this.testExecutor;
    }

    public void setTestExecutor(String testExecutor) {
        this.testExecutor = testExecutor;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGitCryptKey() {
        return this.gitCryptKey;
    }

    public void setGitCryptKey(String gitCryptKey) {
        this.gitCryptKey = gitCryptKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ClazzFoldersFilter.class)
    public List<String> getClazzFolders() {
        return this.clazzFolders;
    }

    public void setClazzFolders(List<String> clazzFolders) {
        this.clazzFolders = clazzFolders;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=TestClazzFoldersFilter.class)
    public List<String> getTestClazzFolders() {
        return this.testClazzFolders;
    }

    public void setTestClazzFolders(List<String> testClazzFolders) {
        this.testClazzFolders = testClazzFolders;
    }

    public void setCreateDetailDebugFiles(boolean createDetailDebugFiles) {
        this.createDetailDebugFiles = createDetailDebugFiles;
    }

    public boolean isCreateDetailDebugFiles() {
        return this.createDetailDebugFiles;
    }

    public void setPrintCompilation(boolean printCompilation) {
        this.printCompilation = printCompilation;
    }

    public boolean isPrintCompilation() {
        return this.printCompilation;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGradleJavaPluginName() {
        return null;
    }

    public void setGradleJavaPluginName(String gradleJavaPluginName) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGradleSpringBootPluginName() {
        return null;
    }

    public void setGradleSpringBootPluginName(String gradleSpringBootPluginName) {
    }

    @JsonIgnore
    public List<String> getAllClazzFolders() {
        LinkedList<String> allFolders = new LinkedList<String>();
        allFolders.addAll(this.clazzFolders);
        allFolders.addAll(this.testClazzFolders);
        return allFolders;
    }

    public boolean isUseAnbox() {
        return this.useAnbox;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public void setUseAnbox(boolean useAnbox) {
        this.useAnbox = useAnbox;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAndroidCompileSdkVersion() {
        return this.androidCompileSdkVersion;
    }

    public void setAndroidCompileSdkVersion(String androidCompileSdkVersion) {
        this.androidCompileSdkVersion = androidCompileSdkVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAndroidMinSdkVersion() {
        return this.androidMinSdkVersion;
    }

    public void setAndroidMinSdkVersion(String androidMinSdkVersion) {
        this.androidMinSdkVersion = androidMinSdkVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAndroidTargetSdkVersion() {
        return this.androidTargetSdkVersion;
    }

    public void setAndroidTargetSdkVersion(String androidTargetSdkVersion) {
        this.androidTargetSdkVersion = androidTargetSdkVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAndroidManifest() {
        return this.androidManifest;
    }

    public void setAndroidManifest(String androidManifest) {
        this.androidManifest = androidManifest;
    }

    public String getXmx() {
        return this.xmx;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public void setXmx(String xmx) {
        if (!(xmx == null || xmx.isEmpty() || xmx.matches("[0-9]*g") || xmx.matches("[0-9]*m"))) {
            throw new RuntimeException("Please specify heap size either in Gigabyte (e.g. 5g) or Megabyte (e.g. 2048m), but was " + xmx);
        }
        if (xmx != null && !xmx.isEmpty()) {
            this.xmx = xmx;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getAndroidGradleTasks() {
        return this.androidGradleTasks;
    }

    public void setAndroidGradleTasks(List<String> androidGradleTasks) {
        this.androidGradleTasks = androidGradleTasks;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAndroidGradleVersion() {
        return this.androidGradleVersion;
    }

    public void setAndroidGradleVersion(String androidGradleVersion) {
        this.androidGradleVersion = androidGradleVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAndroidTestPackageName() {
        return this.androidTestPackageName;
    }

    public void setAndroidTestPackageName(String androidTestPackageName) {
        this.androidTestPackageName = androidTestPackageName;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getIncreaseVariableValues() {
        return this.increaseVariableValues;
    }

    public void setIncreaseVariableValues(List<String> increaseVariableValues) {
        this.increaseVariableValues = increaseVariableValues;
    }

    public void setGoalCompilerVersion(String goalCompilerVersion) {
        this.goalCompilerVersion = goalCompilerVersion;
    }

    public String getGoalCompilerVersion() {
        return this.goalCompilerVersion;
    }

    private static final class TestClazzFoldersFilter {
        private TestClazzFoldersFilter() {
        }

        public boolean equals(Object obj) {
            List list;
            if (obj instanceof List && (list = (List)obj).size() == 3 && list.get(0).equals(ExecutionConfig.SRC_TEST_JAVA) && list.get(1).equals(ExecutionConfig.SRC_TEST) && list.get(2).equals(ExecutionConfig.SRC_ANDROID_TEST_JAVA)) {
                return true;
            }
            return super.equals(obj);
        }
    }

    private static final class ClazzFoldersFilter {
        private ClazzFoldersFilter() {
        }

        public boolean equals(Object obj) {
            List list;
            if (obj instanceof List && (list = (List)obj).size() == 2 && list.get(0).equals(ExecutionConfig.SRC_MAIN_JAVA) && list.get(1).equals(ExecutionConfig.SRC_JAVA)) {
                return true;
            }
            return super.equals(obj);
        }
    }

    private static final class TestTransformerFilter {
        private TestTransformerFilter() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof String && ExecutionConfig.DEFAULT_TEST_TRANSFORMER.equals(obj)) {
                return true;
            }
            return super.equals(obj);
        }
    }

    private static final class TestExecutorFilter {
        private TestExecutorFilter() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof String && ExecutionConfig.DEFAULT_TEST_EXECUTOR.equals(obj)) {
                return true;
            }
            return super.equals(obj);
        }
    }
}

