/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.dagere.kopeme.kieker.writer.WritingType;
import java.io.Serializable;
import java.util.LinkedHashSet;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;

public class KiekerConfig
implements Serializable {
    public static final boolean USE_CIRCULAR_QUEUE_DEFAULT = false;
    public static final int DEFAULT_WRITE_INTERVAL = 5000;
    public static final int DEFAULT_KIEKER_QUEUE_SIZE = 10000000;
    public static final int DEFAULT_TRACE_SIZE_IN_MB = 100;
    public static final int DEFAULT_KIEKER_WAIT_TIME = 5;
    private static final long serialVersionUID = 3129231099963995908L;
    private boolean useKieker = false;
    private boolean useSourceInstrumentation = true;
    private boolean useSelectiveInstrumentation = true;
    private boolean useAggregation = true;
    private boolean measureAdded = false;
    private boolean useCircularQueue = false;
    private boolean enableAdaptiveMonitoring = false;
    private boolean adaptiveInstrumentation = false;
    private int kiekerAggregationInterval = 5000;
    private AllowedKiekerRecord record = AllowedKiekerRecord.DURATION;
    private boolean onlyOneCallRecording = false;
    private boolean extractMethod = false;
    private long traceSizeInMb = 100L;
    private long kiekerQueueSize = 10000000L;
    private boolean createDefaultConstructor = true;
    private int kiekerWaitTime = 5;
    private WritingType writingType = WritingType.BinaryAggregated;
    private boolean disableKiekerKoPeMe = false;
    private LinkedHashSet<String> excludeForTracing = new LinkedHashSet();

    public KiekerConfig() {
    }

    public KiekerConfig(boolean useKieker) {
        this.useKieker = useKieker;
    }

    public KiekerConfig(KiekerConfig other) {
        this.useKieker = other.useKieker;
        this.useSourceInstrumentation = other.useSourceInstrumentation;
        this.useSelectiveInstrumentation = other.useSelectiveInstrumentation;
        this.useAggregation = other.useAggregation;
        this.measureAdded = other.measureAdded;
        this.useCircularQueue = other.useCircularQueue;
        this.enableAdaptiveMonitoring = other.enableAdaptiveMonitoring;
        this.adaptiveInstrumentation = other.adaptiveInstrumentation;
        this.kiekerAggregationInterval = other.kiekerAggregationInterval;
        this.record = other.record;
        this.onlyOneCallRecording = other.onlyOneCallRecording;
        this.extractMethod = other.extractMethod;
        this.traceSizeInMb = other.traceSizeInMb;
        this.kiekerQueueSize = other.kiekerQueueSize;
        this.excludeForTracing = other.excludeForTracing;
        this.createDefaultConstructor = other.createDefaultConstructor;
        this.kiekerWaitTime = other.kiekerWaitTime;
    }

    public void check() {
        if (this.kiekerAggregationInterval != 5000 && !this.useAggregation) {
            throw new RuntimeException("The write interval only works with aggregation, non-aggregated writing will write every record directly to hard disc");
        }
        if (!this.useSourceInstrumentation && this.extractMethod) {
            throw new RuntimeException("Deactivated source instrumentation and usage of extraction is not possible!");
        }
        if (this.traceSizeInMb < 1L) {
            throw new RuntimeException("Trace size in MB need to be at least 1, but was " + this.traceSizeInMb);
        }
    }

    public boolean isUseKieker() {
        return this.useKieker;
    }

    public void setUseKieker(boolean useKieker) {
        this.useKieker = useKieker;
    }

    public int getKiekerWaitTime() {
        return this.kiekerWaitTime;
    }

    public void setKiekerWaitTime(int kiekerWaitTime) {
        this.kiekerWaitTime = kiekerWaitTime;
    }

    public boolean isUseSourceInstrumentation() {
        return this.useSourceInstrumentation;
    }

    public void setUseSourceInstrumentation(boolean useSourceInstrumentation) {
        this.useSourceInstrumentation = useSourceInstrumentation;
    }

    public boolean isUseSelectiveInstrumentation() {
        return this.useSelectiveInstrumentation;
    }

    public void setUseSelectiveInstrumentation(boolean useSelectiveInstrumentation) {
        this.useSelectiveInstrumentation = useSelectiveInstrumentation;
    }

    public boolean isUseAggregation() {
        return this.useAggregation;
    }

    public void setUseAggregation(boolean useAggregation) {
        this.useAggregation = useAggregation;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isMeasureAdded() {
        return this.measureAdded;
    }

    public void setMeasureAdded(boolean measureAdded) {
        this.measureAdded = measureAdded;
    }

    public boolean isUseCircularQueue() {
        return this.useCircularQueue;
    }

    public void setUseCircularQueue(boolean useCircularQueue) {
        this.useCircularQueue = useCircularQueue;
    }

    public boolean isEnableAdaptiveMonitoring() {
        return this.enableAdaptiveMonitoring;
    }

    public void setEnableAdaptiveMonitoring(boolean enableAdaptiveMonitoring) {
        this.enableAdaptiveMonitoring = enableAdaptiveMonitoring;
    }

    public boolean isAdaptiveInstrumentation() {
        return this.adaptiveInstrumentation;
    }

    public void setAdaptiveInstrumentation(boolean adaptiveInstrumentation) {
        this.adaptiveInstrumentation = adaptiveInstrumentation;
    }

    public int getKiekerAggregationInterval() {
        return this.kiekerAggregationInterval;
    }

    public void setKiekerAggregationInterval(int kiekerAggregationInterval) {
        this.kiekerAggregationInterval = kiekerAggregationInterval;
    }

    public AllowedKiekerRecord getRecord() {
        return this.record;
    }

    public void setRecord(AllowedKiekerRecord record) {
        this.record = record == null ? AllowedKiekerRecord.OPERATIONEXECUTION : record;
    }

    public boolean isOnlyOneCallRecording() {
        return this.onlyOneCallRecording;
    }

    public void setOnlyOneCallRecording(boolean onlyOneCallRecording) {
        this.onlyOneCallRecording = onlyOneCallRecording;
    }

    public boolean isExtractMethod() {
        return this.extractMethod;
    }

    public void setExtractMethod(boolean extractMethod) {
        this.extractMethod = extractMethod;
    }

    public long getTraceSizeInMb() {
        return this.traceSizeInMb;
    }

    public void setTraceSizeInMb(long traceSizeInMb) {
        this.traceSizeInMb = traceSizeInMb;
    }

    public long getKiekerQueueSize() {
        return this.kiekerQueueSize;
    }

    public void setKiekerQueueSize(long kiekerQueueSize) {
        this.kiekerQueueSize = kiekerQueueSize;
    }

    public LinkedHashSet<String> getExcludeForTracing() {
        return this.excludeForTracing;
    }

    public void setExcludeForTracing(LinkedHashSet<String> excludeForTracing) {
        this.excludeForTracing = excludeForTracing;
    }

    public boolean isCreateDefaultConstructor() {
        return this.createDefaultConstructor;
    }

    public void setCreateDefaultConstructor(boolean createDefaultConstructor) {
        this.createDefaultConstructor = createDefaultConstructor;
    }

    public WritingType getWritingType() {
        return this.writingType;
    }

    public void setWritingType(WritingType writingType) {
        this.writingType = writingType;
    }

    public boolean isDisableKiekerKoPeMe() {
        return this.disableKiekerKoPeMe;
    }

    public void setDisableKiekerKoPeMe(boolean disableKiekerKoPeMe) {
        this.disableKiekerKoPeMe = disableKiekerKoPeMe;
    }
}

