/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.MeasurementStrategy;
import de.dagere.peass.config.StatisticsConfig;
import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.config.parameters.KiekerConfigMixin;
import de.dagere.peass.config.parameters.MeasurementConfigurationMixin;
import de.dagere.peass.config.parameters.StatisticsConfigMixin;
import java.io.Serializable;

public class MeasurementConfig
implements Serializable {
    private static final long serialVersionUID = -6936740902708676182L;
    public static final MeasurementConfig DEFAULT = new MeasurementConfig(30);
    private final int vms;
    private boolean earlyStop = true;
    private int warmup = 0;
    private int iterations = 1;
    private int repetitions = 1;
    private boolean logFullData = true;
    private boolean useGC = false;
    private boolean directlyMeasureKieker = false;
    private boolean callSyncBetweenVMs = true;
    private int waitTimeBetweenVMs = 1000;
    private int maxLogSizeInMb = 100;
    private final KiekerConfig kiekerConfig;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean saveAll = true;
    private String javaVersion = System.getProperty("java.version");
    private MeasurementStrategy measurementStrategy = MeasurementStrategy.PARALLEL;
    private StatisticsConfig statisticsConfig = new StatisticsConfig();
    private final ExecutionConfig executionConfig;
    private FixedCommitConfig fixedCommitConfig;

    public MeasurementConfig(int vms) {
        this.executionConfig = new ExecutionConfig(20L);
        this.kiekerConfig = new KiekerConfig();
        this.fixedCommitConfig = new FixedCommitConfig();
        this.vms = vms;
        this.checkParameters(vms);
    }

    private void checkParameters(int vms) {
        if (vms < 1) {
            throw new RuntimeException("Less than 2 VM executions is not possible");
        }
    }

    public MeasurementConfig(int vms, ExecutionConfig executionConfig, KiekerConfig kiekerConfig) {
        this.executionConfig = new ExecutionConfig(executionConfig);
        this.vms = vms;
        this.kiekerConfig = new KiekerConfig(kiekerConfig);
        this.checkParameters(vms);
    }

    public MeasurementConfig(int vms, String commit, String commitOld) {
        this.executionConfig = new ExecutionConfig(20L);
        this.kiekerConfig = new KiekerConfig();
        this.fixedCommitConfig = new FixedCommitConfig();
        this.vms = vms;
        this.fixedCommitConfig.setCommit(commit);
        this.fixedCommitConfig.setCommitOld(commitOld);
        this.checkParameters(vms);
    }

    public MeasurementConfig(MeasurementConfigurationMixin mixin, ExecutionConfigMixin executionMixin, StatisticsConfigMixin statisticMixin, KiekerConfigMixin kiekerConfigMixin) {
        this.executionConfig = executionMixin.getExecutionConfig();
        this.kiekerConfig = kiekerConfigMixin.getKiekerConfig();
        this.kiekerConfig.setRecord(mixin.getRecord());
        this.statisticsConfig = statisticMixin.getStasticsConfig();
        this.fixedCommitConfig = new FixedCommitConfig();
        this.vms = mixin.getVms();
        this.setEarlyStop(mixin.isEarlyStop());
        this.getKiekerConfig().setUseKieker(mixin.isUseKieker());
        this.setIterations(mixin.getIterations());
        this.setWarmup(mixin.getWarmup());
        this.setRepetitions(mixin.getRepetitions());
        this.setMaxLogSizeInMb(mixin.getMaxLogSizeInMb());
        this.setUseGC(mixin.isUseGC());
        this.setMeasurementStrategy(mixin.getMeasurementStrategy());
        this.directlyMeasureKieker = mixin.isDirectlyMeasureKieker();
        this.saveAll = !mixin.isSaveNothing();
        this.checkParameters(this.vms);
    }

    @JsonCreator
    public MeasurementConfig(@JsonProperty(value="vms") int vms, @JsonProperty(value="earlystop") boolean earlyStop) {
        this.executionConfig = new ExecutionConfig();
        this.kiekerConfig = new KiekerConfig();
        this.vms = vms;
        this.earlyStop = earlyStop;
    }

    public MeasurementConfig(long timeout, int vms, boolean earlyStop, String commit, String commitOld) {
        this.executionConfig = new ExecutionConfig();
        this.executionConfig.setTimeout(timeout);
        this.fixedCommitConfig = new FixedCommitConfig();
        this.fixedCommitConfig.setCommit(commit);
        this.fixedCommitConfig.setCommitOld(commitOld);
        this.kiekerConfig = new KiekerConfig();
        this.vms = vms;
        this.earlyStop = earlyStop;
    }

    public MeasurementConfig(MeasurementConfig other) {
        this.executionConfig = new ExecutionConfig(other.getExecutionConfig());
        this.statisticsConfig = new StatisticsConfig(other.getStatisticsConfig());
        this.kiekerConfig = new KiekerConfig(other.getKiekerConfig());
        this.fixedCommitConfig = new FixedCommitConfig(other.getFixedCommitConfig());
        this.vms = other.vms;
        this.earlyStop = other.earlyStop;
        this.warmup = other.warmup;
        this.iterations = other.iterations;
        this.repetitions = other.repetitions;
        this.logFullData = other.logFullData;
        this.useGC = other.useGC;
        this.javaVersion = other.javaVersion;
        this.measurementStrategy = other.measurementStrategy;
        this.saveAll = other.saveAll;
        this.waitTimeBetweenVMs = other.waitTimeBetweenVMs;
        this.directlyMeasureKieker = other.directlyMeasureKieker;
        this.maxLogSizeInMb = other.maxLogSizeInMb;
    }

    public FixedCommitConfig getFixedCommitConfig() {
        return this.fixedCommitConfig;
    }

    public void setFixedCommitConfig(FixedCommitConfig fixedVersionConfig) {
        this.fixedCommitConfig = fixedVersionConfig;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public void setSaveAll(boolean saveAll) {
        this.saveAll = saveAll;
    }

    public boolean isSaveAll() {
        return this.saveAll;
    }

    public boolean isUseGC() {
        return this.useGC;
    }

    public void setUseGC(boolean useGC) {
        this.useGC = useGC;
    }

    @JsonIgnore
    public long getTimeoutInSeconds() {
        return this.executionConfig.getTimeoutInSeconds();
    }

    public int getVms() {
        return this.vms;
    }

    public boolean isEarlyStop() {
        return this.earlyStop;
    }

    public void setEarlyStop(boolean earlyStop) {
        this.earlyStop = earlyStop;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public void setWarmup(int warmup) {
        this.warmup = warmup;
    }

    public int getIterations() {
        return this.iterations;
    }

    @JsonIgnore
    public int getAllIterations() {
        return this.iterations + this.warmup;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
        if (iterations < 1) {
            throw new RuntimeException("Iterations smaller than 1 are not allowed!");
        }
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
    }

    public boolean isLogFullData() {
        return this.logFullData;
    }

    public void setLogFullData(boolean logFullData) {
        this.logFullData = logFullData;
    }

    @JsonIgnore
    public boolean isUseKieker() {
        return this.kiekerConfig.isUseKieker();
    }

    public void setUseKieker(boolean useKieker) {
        this.kiekerConfig.setUseKieker(useKieker);
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public MeasurementStrategy getMeasurementStrategy() {
        return this.measurementStrategy;
    }

    public void setMeasurementStrategy(MeasurementStrategy measurementStrategy) {
        this.measurementStrategy = measurementStrategy;
    }

    public boolean isCallSyncBetweenVMs() {
        return this.callSyncBetweenVMs;
    }

    public void setCallSyncBetweenVMs(boolean callSyncBetweenVMs) {
        this.callSyncBetweenVMs = callSyncBetweenVMs;
    }

    public int getWaitTimeBetweenVMs() {
        return this.waitTimeBetweenVMs;
    }

    public void setWaitTimeBetweenVMs(int waitTimeBetweenVMs) {
        this.waitTimeBetweenVMs = waitTimeBetweenVMs;
    }

    public int getMaxLogSizeInMb() {
        return this.maxLogSizeInMb;
    }

    public void setMaxLogSizeInMb(int logSizeInMb) {
        this.maxLogSizeInMb = logSizeInMb;
    }

    @JsonIgnore
    public int getNodeWarmup() {
        int aggregationfactor = this.getKiekerConfig().isUseAggregation() ? this.getRepetitions() : 1;
        int warmup = this.getWarmup() * this.getRepetitions() / aggregationfactor;
        return warmup;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDirectlyMeasureKieker() {
        return this.directlyMeasureKieker;
    }

    public void setDirectlyMeasureKieker(boolean directlyMeasureKieker) {
        this.directlyMeasureKieker = directlyMeasureKieker;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public KiekerConfig getKiekerConfig() {
        return this.kiekerConfig;
    }
}

