/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.dagere.peass.config.StatisticalTests;
import java.io.Serializable;

public class StatisticsConfig
implements Serializable {
    private static final long serialVersionUID = -6193031432004031500L;
    private double type1error = 0.01;
    private double type2error = 0.01;
    private double outlierFactor = 3.29;
    private StatisticalTests statisticTest = StatisticalTests.MANN_WHITNEY_TEST;
    private double maximumRelativeDeviation = Double.MAX_VALUE;
    public static final double DEFAULT_OUTLIER_FACTOR = 3.29;

    public StatisticsConfig() {
    }

    public StatisticsConfig(StatisticsConfig other) {
        this.type1error = other.type1error;
        this.type2error = other.type2error;
        this.outlierFactor = other.outlierFactor;
        this.statisticTest = other.statisticTest;
        this.maximumRelativeDeviation = other.maximumRelativeDeviation;
    }

    public double getType1error() {
        return this.type1error;
    }

    public void setType1error(double type1error) {
        this.type1error = type1error;
        if (type1error <= 0.0 || type1error >= 1.0) {
            throw new RuntimeException("Configured illegal type1error: " + type1error);
        }
    }

    public double getType2error() {
        return this.type2error;
    }

    public void setType2error(double type2error) {
        this.type2error = type2error;
        if (type2error <= 0.0 || type2error >= 1.0) {
            throw new RuntimeException("Configured illegal type1error: " + this.type1error);
        }
    }

    public double getOutlierFactor() {
        return this.outlierFactor;
    }

    public void setOutlierFactor(double outlierFactor) {
        this.outlierFactor = outlierFactor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=MaximumRelativeDeviationFilter.class)
    public double getMaximumRelativeDeviation() {
        return this.maximumRelativeDeviation;
    }

    public void setMaximumRelativeDeviation(double maximumRelativeDeviation) {
        this.maximumRelativeDeviation = maximumRelativeDeviation;
    }

    public StatisticalTests getStatisticTest() {
        return this.statisticTest;
    }

    public void setStatisticTest(StatisticalTests statisticTest) {
        this.statisticTest = statisticTest;
    }

    public static class MaximumRelativeDeviationFilter {
        public boolean equals(Object obj) {
            if (obj instanceof Double) {
                return Double.MAX_VALUE == (Double)obj;
            }
            return false;
        }
    }
}

