/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config;

import java.io.Serializable;

public class TestSelectionConfig
implements Serializable {
    private static final long serialVersionUID = -3734493960077455640L;
    private final int threads;
    private final boolean doNotUpdateDependencies;
    private final boolean generateTraces;
    private final boolean generateCoverageSelection;
    private final boolean generateTwiceExecutability;
    private final boolean skipProcessSuccessRuns;
    private final boolean writeAsZip;

    public TestSelectionConfig(int threads, boolean doNotUpdateDependencies) {
        this.threads = threads;
        this.doNotUpdateDependencies = doNotUpdateDependencies;
        if (doNotUpdateDependencies) {
            this.generateTraces = false;
            this.generateCoverageSelection = false;
        } else {
            this.generateTraces = true;
            this.generateCoverageSelection = true;
        }
        this.generateTwiceExecutability = false;
        this.skipProcessSuccessRuns = false;
        this.writeAsZip = false;
    }

    public TestSelectionConfig(int threads, boolean doNotUpdateDependencies, boolean generateViews, boolean generateCoverageSelection, boolean generateTwiceExecutability, boolean writeAsZip) {
        this.threads = threads;
        this.doNotUpdateDependencies = doNotUpdateDependencies;
        this.generateTraces = generateViews;
        this.generateCoverageSelection = generateCoverageSelection;
        this.generateTwiceExecutability = generateTwiceExecutability;
        this.writeAsZip = writeAsZip;
        this.skipProcessSuccessRuns = false;
        this.check();
    }

    public TestSelectionConfig(int threads, boolean doNotUpdateDependencies, boolean generateTraces, boolean generateCoverageSelection, boolean generateTwiceExecutability, boolean skipProcessSuccessRuns, boolean writeAsZip) {
        this.threads = threads;
        this.doNotUpdateDependencies = doNotUpdateDependencies;
        this.generateTraces = generateTraces;
        this.generateCoverageSelection = generateCoverageSelection;
        this.generateTwiceExecutability = generateTwiceExecutability;
        this.skipProcessSuccessRuns = skipProcessSuccessRuns;
        this.writeAsZip = writeAsZip;
        this.check();
    }

    private void check() {
        if (this.doNotUpdateDependencies && this.generateTraces) {
            throw new RuntimeException("isGenerateViews may only be true if doNotUpdateDependencies is false! If doNotUpdateDependencies is set, no traces are generates; then it is not possible to generate views");
        }
        if (!this.generateTraces && this.generateCoverageSelection) {
            throw new RuntimeException("generateCoverageSelection may only be true if generateViews is true! If generateViews is disabled, no traces are generates; then it is not possible to select by code coverage");
        }
        if (!this.generateTraces && this.generateTwiceExecutability) {
            throw new RuntimeException("If generateTwiceExecutability is true, generateTraces should be true.");
        }
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean isDoNotUpdateDependencies() {
        return this.doNotUpdateDependencies;
    }

    public boolean isGenerateTraces() {
        return this.generateTraces;
    }

    public boolean isGenerateCoverageSelection() {
        return this.generateCoverageSelection;
    }

    public boolean isGenerateTwiceExecutability() {
        return this.generateTwiceExecutability;
    }

    public boolean isSkipProcessSuccessRuns() {
        return this.skipProcessSuccessRuns;
    }

    public boolean isWriteAsZip() {
        return this.writeAsZip;
    }
}

