/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config.parameters;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.WorkloadType;
import java.util.List;
import picocli.CommandLine;

public class ExecutionConfigMixin {
    public static final String CLAZZ_FOLDERS_DEFAULT = "src/main/java:src/java";
    public static final String TEST_FOLDERS_DEFAULT = "src/test/java:src/test:src/androidTest/java/";
    @CommandLine.Option(names={"-timeout", "--timeout"}, description={"Timeout in minutes for each VM start"})
    protected long timeout = 5L;
    @CommandLine.Option(names={"-includes", "--includes"}, split=";", description={"Testcases for inclusion (default: empty, includes all tests). Example: \"my.package.Clazz#myMethod;my.otherpackage.ClazzB#*\""})
    protected String[] includes;
    @CommandLine.Option(names={"-excludes", "--excludes"}, split=";", description={"Testcases for exclusion (default: empty, excludes no test). Example: \"my.package.Clazz#myMethod;my.otherpackage.ClazzB#*\""})
    protected String[] excludes;
    @CommandLine.Option(names={"-includeByRule", "--includeByRule"}, split=";", description={"Rules that should be included (if defined, only test classes having exactly this rule(s) will be used)"})
    protected String[] includeByRule;
    @CommandLine.Option(names={"-excludeByRule", "--excludeByRule"}, split=";", description={"Rules that should be included (if defined, test classes will be excluded that use this rule, even if included by includeByRule or includes)"})
    protected String[] excludeByRule;
    @CommandLine.Option(names={"-forbiddenMethods", "--forbiddenMethods"}, description={"Testcases that call one of these methods are excluded"})
    protected String[] forbiddenMethods;
    @CommandLine.Option(names={"-startcommit", "--startcommit"}, description={"First commit that should be analysed - do not use together with commit and commitOld!"})
    protected String startcommit;
    @CommandLine.Option(names={"-endcommit", "--endcommit"}, description={"Last commit that should be analysed - do not use together with commit and commitOld! "})
    protected String endcommit;
    @CommandLine.Option(names={"-linearizeHistory", "--linearizeHistory"}, description={"Set tracking-model of commit history - by default is linearized (true). For Non-linear model, change it to false"})
    protected boolean linearizeHistory = true;
    @CommandLine.Option(names={"-testGoal", "--testGoal"}, description={"Test goal that should be used; default testRelease for Android projects and test for all others. If you want to use test<VariantName> for Android, please specify a goal (i.e. task name) here.If you want to run integration tests in maven e.g. by calling failsafe, also specify it here. "})
    protected String testGoal;
    @CommandLine.Option(names={"-executableCheckGoals", "--executableCheckGoals"}, split=";", description={"Goals that should be used for checking whether a commit is executable *currently only for gradle* (by default testClasses and assemble for non-android projects, assemble for android projects)"})
    protected String[] executableCheckGoals;
    @CommandLine.Option(names={"-cleanGoal", "--cleanGoal"}, description={"Clean goal that is called before the test execution *in Gradle*; defaults to cleanTest."})
    protected String cleanGoal;
    @CommandLine.Option(names={"-pl", "--pl"}, description={"Projectlist (-pl) argument for maven (e.g. :submodule) - only the submodule and its dependencies are analyzed (using -am)"})
    protected String pl;
    @CommandLine.Option(names={"-workloadType", "--workloadType"}, description={"Which workload should be executed - by default JUNIT, can be changed to JMH"})
    public WorkloadType workloadType = WorkloadType.JUNIT;
    @CommandLine.Option(names={"-testExecutor", "--testExecutor"}, description={"Set test executor (should be specified by plugin; not usable with pure Peass)"})
    public String testExecutor;
    @CommandLine.Option(names={"-testTransformer", "--testTransformer"}, description={"Set test transformer (should be specified by plugin; not usable with pure Peass)"})
    public String testTransformer;
    @CommandLine.Option(names={"-gitCryptKey", "--gitCryptKey"}, description={"If repository uses git-crypt, you should provide location of git-crypt-keyfile)"})
    protected String gitCryptKey = System.getenv("GIT_CRYPT_KEY");
    @CommandLine.Option(names={"-useTieredCompilation", "--useTieredCompilation"}, description={"Activate -XX:-TieredCompilation for all measured processes"})
    protected boolean useTieredCompilation = false;
    @CommandLine.Option(names={"-executeBeforeClassInMeasurement", "--executeBeforeClassInMeasurement"}, description={"Execute @BeforeClass / @BeforeAll in measurement loop"})
    protected boolean executeBeforeClassInMeasurement = false;
    @CommandLine.Option(names={"-clearMockitoCaches", "--clearMockitoCaches"}, description={"Clear Mockito cache by adding a method that calls Mockito.clearAllCaches() in every repetition"})
    protected boolean clearMockitoCaches = false;
    @CommandLine.Option(names={"-removeSnapshots", "--removeSnapshots"}, description={"Activates removing SNAPSHOTS (if older versions should be analysed, this should be activated; for performance measurement in CI, this should not be activated)"})
    protected boolean removeSnapshots = false;
    @CommandLine.Option(names={"-useAlternativeBuildfile", "--useAlternativeBuildfile"}, description={"Use alternative buildfile when existing (searches for alternative_build.gradle and replaces build.gradle with the file; required e.g. if the default build process contains certification)"})
    protected boolean useAlternativeBuildfile = false;
    @CommandLine.Option(names={"-classFolder", "--classFolder"}, description={"Folder that contains java classes"})
    protected String clazzFolder = "src/main/java:src/java";
    @CommandLine.Option(names={"-testClassFolder", "--testClassFolder"}, description={"Folder that contains test classes"})
    protected String testClazzFolder = "src/test/java:src/test:src/androidTest/java/";
    @CommandLine.Option(names={"-excludeLog4jToSlf4j", "--excludeLog4jToSlf4j"}, description={"Exclude log4j-to-slf4j (required, if other logging implementation should be used)"})
    protected boolean excludeLog4jToSlf4j = false;
    @CommandLine.Option(names={"-excludeLog4jSlf4jImpl", "--excludeLog4jSlf4jImpl"}, description={"Exclude log4j-slf4j-impl (required, if other logging implementation should be used)"})
    protected boolean excludeLog4jSlf4jImpl = false;
    @CommandLine.Option(names={"-dontRedirectToNull", "--dontRedirectToNull"}, description={"Activates showing the standard output of the testcase (by default, it is redirected to null)"})
    protected boolean dontRedirectToNull = false;
    @CommandLine.Option(names={"-showStart", "--showStart"}, description={"Activates showing and end of each KoPeMe iteration (default false, and always activated for regression test selection)"})
    protected boolean showStart = false;
    @CommandLine.Option(names={"-printCompilation", "--printCompilation"}, description={"Prints the compilation output (by adding -XX:+PrintCompilation and -X to the maven call, to avoid redirecting output to the dumpstream file)"})
    protected boolean printCompilation = false;
    @CommandLine.Option(names={"-onlyMeasureWorkload", "--onlyMeasureWorkload"}, description={"Only measure workload (no @Before/@After)"})
    protected boolean onlyMeasureWorkload = false;
    @CommandLine.Option(names={"-properties", "--properties"}, description={"Sets the properties that should be passed to the test (e.g. \"-Dmy.var=5\")"})
    public String properties;
    @CommandLine.Option(names={"-heapSize", "--heapSize"}, description={"Sets the heap size of the child VMs by setting something like -Xmx5g in the buildfile; only pass the size (e.g. 5g or 2048m, not -Xmx5g nor -Xmx2024m)"})
    public String heapSize;
    @CommandLine.Option(names={"-useAnbox", "--useAnbox"}, description={"Activates usage of Anbox measurement features (currently experimental)"})
    protected boolean useAnbox = false;
    @CommandLine.Option(names={"-androidCompileSdkVersion", "--androidCompileSdkVersion"}, description={"Overrides compileSdkVersion specidifed in gradle file"})
    protected String androidCompileSdkVersion;
    @CommandLine.Option(names={"-androidMinSdkVersion", "--androidMinSdkVersion"}, description={"Overrides minSdkVersion specidifed in gradle file"})
    protected String androidMinSdkVersion;
    @CommandLine.Option(names={"-androidTargetSdkVersion", "--androidTargetSdkVersion"}, description={"Overrides targetSdkVersion specidifed in gradle file"})
    protected String androidTargetSdkVersion;
    @CommandLine.Option(names={"-androidManifest", "--androidManifest"}, description={"Sets the relative path to the main Android manifest file (e.g. app/src/main/AndroidManifest.xml)"})
    protected String androidManifest;
    @CommandLine.Option(names={"-androidGradleTasks", "--androidGradleTasks"}, split=";", description={"List of tasks that will be executed to compile and install the Android tests"})
    protected String[] androidGradleTasks;
    @CommandLine.Option(names={"-androidGradleVersion", "--androidGradleVersion"}, description={"Overrides the existing Gradle version with the specified version"})
    protected String androidGradleVersion;
    @CommandLine.Option(names={"-androidTestPackageName", "--androidTestPackageName"}, description={"Sets the test package name for every test."})
    protected String androidTestPackageName;
    @CommandLine.Option(names={"-increaseVariableValues", "--increaseVariableValues"}, split=";", description={"List of variables and values to be modified (default: empty). Example: \"package.Clazz.variable:value;otherPackage.otherClazz.otherVariable:otherValue\""})
    protected String[] increaseVariableValues;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludeByRule(String[] includeByRule) {
        this.includeByRule = includeByRule;
    }

    public String[] getIncludeByRule() {
        return this.includeByRule;
    }

    public void setExcludeByRule(String[] excludeByRule) {
        this.excludeByRule = excludeByRule;
    }

    public String[] getExcludeByRule() {
        return this.excludeByRule;
    }

    public void setTestGoal(String testGoal) {
        this.testGoal = testGoal;
    }

    public String getTestGoal() {
        return this.testGoal;
    }

    public void setExecutableCheckGoals(String[] executableCheckGoals) {
        this.executableCheckGoals = executableCheckGoals;
    }

    public String[] getExecutableCheckGoals() {
        return this.executableCheckGoals;
    }

    public void setCleanGoal(String cleanGoal) {
        this.cleanGoal = cleanGoal;
    }

    public String getCleanGoal() {
        return this.cleanGoal;
    }

    public String getStartcommit() {
        return this.startcommit;
    }

    public void setStartcommit(String startcommit) {
        this.startcommit = startcommit;
    }

    public String getEndcommit() {
        return this.endcommit;
    }

    public void setEndcommit(String endcommit) {
        this.endcommit = endcommit;
    }

    public void setLinearizeHistory(boolean linearizeHistory) {
        this.linearizeHistory = linearizeHistory;
    }

    public boolean isLinearizeHistory() {
        return this.linearizeHistory;
    }

    public void setPl(String pl) {
        this.pl = pl;
    }

    public String getPl() {
        return this.pl;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    public void setRemoveSnapshots(boolean removeSnapshots) {
        this.removeSnapshots = removeSnapshots;
    }

    public boolean isUseAlternativeBuildfile() {
        return this.useAlternativeBuildfile;
    }

    public void setUseAlternativeBuildfile(boolean useAlternativeBuildfile) {
        this.useAlternativeBuildfile = useAlternativeBuildfile;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String[] getForbiddenMethods() {
        return this.forbiddenMethods;
    }

    public void setForbiddenMethods(String[] forbiddenMethods) {
        this.forbiddenMethods = forbiddenMethods;
    }

    public WorkloadType getWorkloadType() {
        return this.workloadType;
    }

    public void setWorkloadType(WorkloadType workloadType) {
        this.workloadType = workloadType;
    }

    public String getTestExecutor() {
        return this.testExecutor;
    }

    public void setTestExecutor(String testExecutor) {
        this.testExecutor = testExecutor;
    }

    public String getTestTransformer() {
        return this.testTransformer;
    }

    public void setTestTransformer(String testTransformer) {
        this.testTransformer = testTransformer;
    }

    public String getGitCryptKey() {
        return this.gitCryptKey;
    }

    public void setGitCryptKey(String gitCryptKey) {
        this.gitCryptKey = gitCryptKey;
    }

    public boolean isUseTieredCompilation() {
        return this.useTieredCompilation;
    }

    public void setUseTieredCompilation(boolean useTieredCompilation) {
        this.useTieredCompilation = useTieredCompilation;
    }

    public boolean isExecuteBeforeClassInMeasurement() {
        return this.executeBeforeClassInMeasurement;
    }

    public void setExecuteBeforeClassInMeasurement(boolean executeBeforeClassInMeasurement) {
        this.executeBeforeClassInMeasurement = executeBeforeClassInMeasurement;
    }

    public boolean isClearMockitoCaches() {
        return this.clearMockitoCaches;
    }

    public void setClearMockitoCaches(boolean clearMockitoCaches) {
        this.clearMockitoCaches = clearMockitoCaches;
    }

    public String getClazzFolder() {
        return this.clazzFolder;
    }

    public void setClazzFolder(String clazzFolder) {
        this.clazzFolder = clazzFolder;
    }

    public String getTestClazzFolder() {
        return this.testClazzFolder;
    }

    public void setTestClazzFolder(String testClazzFolder) {
        this.testClazzFolder = testClazzFolder;
    }

    public boolean isExcludeLog4jSlf4jImpl() {
        return this.excludeLog4jSlf4jImpl;
    }

    public void setExcludeLog4jSlf4jImpl(boolean excludeLog4jSlf4jImpl) {
        this.excludeLog4jSlf4jImpl = excludeLog4jSlf4jImpl;
    }

    public boolean isExcludeLog4jToSlf4j() {
        return this.excludeLog4jToSlf4j;
    }

    public void setExcludeLog4jToSlf4j(boolean excludeLog4jToSlf4j) {
        this.excludeLog4jToSlf4j = excludeLog4jToSlf4j;
    }

    public boolean isDontRedirectToNull() {
        return this.dontRedirectToNull;
    }

    public void setDontRedirectToNull(boolean dontRedirectToNull) {
        this.dontRedirectToNull = dontRedirectToNull;
    }

    public boolean isOnlyMeasureWorkload() {
        return this.onlyMeasureWorkload;
    }

    public void setOnlyMeasureWorkload(boolean onlyMeasureWorkload) {
        this.onlyMeasureWorkload = onlyMeasureWorkload;
    }

    public String getHeapSize() {
        return this.heapSize;
    }

    public void setHeapSize(String heapSize) {
        this.heapSize = heapSize;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public boolean isUseAnbox() {
        return this.useAnbox;
    }

    public void setUseAnbox(boolean useAnbox) {
        this.useAnbox = useAnbox;
    }

    public String getAndroidCompileSdkVersion() {
        return this.androidCompileSdkVersion;
    }

    public void setAndroidCompileSdkVersion(String androidCompileSdkVersion) {
        this.androidCompileSdkVersion = androidCompileSdkVersion;
    }

    public String getAndroidMinSdkVersion() {
        return this.androidMinSdkVersion;
    }

    public void setAndroidMinSdkVersion(String androidMinSdkVersion) {
        this.androidMinSdkVersion = androidMinSdkVersion;
    }

    public String getAndroidTargetSdkVersion() {
        return this.androidTargetSdkVersion;
    }

    public void setAndroidTargetSdkVersion(String androidTargetSdkVersion) {
        this.androidTargetSdkVersion = androidTargetSdkVersion;
    }

    public String getAndroidManifest() {
        return this.androidManifest;
    }

    public void setAndroidManifest(String androidManifest) {
        this.androidManifest = androidManifest;
    }

    public String[] getAndroidGradleTasks() {
        return this.androidGradleTasks;
    }

    public void setAndroidGradleTasks(String[] androidGradleTasks) {
        this.androidGradleTasks = androidGradleTasks;
    }

    public String getAndroidGradleVersion() {
        return this.androidGradleVersion;
    }

    public void setAndroidGradleVersion(String androidGradleVersion) {
        this.androidGradleVersion = androidGradleVersion;
    }

    public String getAndroidTestPackageName() {
        return this.androidTestPackageName;
    }

    public void setAndroidTestPackageName(String androidTestPackageName) {
        this.androidTestPackageName = androidTestPackageName;
    }

    public String[] getIncreaseVariableValues() {
        return this.increaseVariableValues;
    }

    public void setIncreaseVariableValues(String[] increaseVariableValues) {
        this.increaseVariableValues = increaseVariableValues;
    }

    public ExecutionConfig getExecutionConfig() {
        boolean executorSet;
        ExecutionConfig config = new ExecutionConfig(this.timeout);
        config.setStartcommit(this.getStartcommit());
        config.setEndcommit(this.getEndcommit());
        config.setLinearizeHistory(this.linearizeHistory);
        config.setTestGoal(this.getTestGoal());
        if (this.getExecutableCheckGoals() != null) {
            for (String executableCheckGoal : this.getExecutableCheckGoals()) {
                config.getExecutableCheckGoals().add(executableCheckGoal);
            }
        }
        config.setCleanGoal(this.getCleanGoal());
        if (this.getIncludes() != null) {
            for (String include : this.getIncludes()) {
                config.getIncludes().add(include);
            }
        }
        if (this.getExcludes() != null) {
            for (String exclude : this.getExcludes()) {
                config.getExcludes().add(exclude);
            }
        }
        if (this.getIncludeByRule() != null) {
            for (String includeByRule : this.getIncludeByRule()) {
                config.getIncludeByRule().add(includeByRule);
            }
        }
        if (this.getExcludeByRule() != null) {
            for (String excludeByRule : this.getExcludeByRule()) {
                config.getExcludeByRule().add(excludeByRule);
            }
        }
        if (this.getForbiddenMethods() != null) {
            for (String forbiddenMethod : this.getForbiddenMethods()) {
                config.getForbiddenMethods().add(forbiddenMethod);
            }
        }
        if (this.getPl() != null) {
            config.setPl(this.pl);
        }
        boolean transformerSet = this.getTestTransformer() != null;
        boolean bl = executorSet = this.getTestExecutor() != null;
        if (transformerSet && executorSet) {
            config.setTestTransformer(this.getTestTransformer());
            config.setTestExecutor(this.getTestExecutor());
        } else {
            if (transformerSet && !executorSet) {
                throw new RuntimeException("If --testTransformer is set by CLI parameters, --testExecutor needs also be set!");
            }
            if (!transformerSet && executorSet) {
                throw new RuntimeException("If --testExecutor is set by CLI parameters, --testTransformer needs also be set!");
            }
            config.setTestTransformer(this.getWorkloadType().getTestTransformer());
            config.setTestExecutor(this.getWorkloadType().getTestExecutor());
        }
        config.setGitCryptKey(this.getGitCryptKey());
        config.setUseTieredCompilation(this.useTieredCompilation);
        config.setRemoveSnapshots(this.removeSnapshots);
        config.setUseAlternativeBuildfile(this.useAlternativeBuildfile);
        config.setRemoveSnapshots(this.removeSnapshots);
        config.setExecuteBeforeClassInMeasurement(this.executeBeforeClassInMeasurement);
        config.setClearMockitoCaches(this.clearMockitoCaches);
        config.setProperties(this.properties);
        config.setXmx(this.heapSize);
        if (this.getClazzFolder() != null) {
            List<String> clazzFolders = ExecutionConfig.buildFolderList(this.getClazzFolder());
            config.setClazzFolders(clazzFolders);
        }
        if (this.getTestClazzFolder() != null) {
            List<String> testClazzFolders = ExecutionConfig.buildFolderList(this.getTestClazzFolder());
            config.setTestClazzFolders(testClazzFolders);
        }
        config.setExcludeLog4jSlf4jImpl(this.excludeLog4jSlf4jImpl);
        config.setExcludeLog4jToSlf4j(this.excludeLog4jToSlf4j);
        config.setRedirectToNull(!this.dontRedirectToNull);
        config.setShowStart(this.showStart);
        config.setOnlyMeasureWorkload(this.onlyMeasureWorkload);
        if (config.isExecuteBeforeClassInMeasurement() && config.isOnlyMeasureWorkload()) {
            throw new RuntimeException("executeBeforeClassInMeasurement may only be activated if onlyMeasureWorkload is deactivated!");
        }
        if (config.isClearMockitoCaches() && !config.isExecuteBeforeClassInMeasurement()) {
            throw new RuntimeException("Currently, clearMockitoCaches is only allowed if executeBeforeClassInMeasurement is also activated!");
        }
        config.setUseAnbox(this.useAnbox);
        config.setAndroidCompileSdkVersion(this.androidCompileSdkVersion);
        config.setAndroidMinSdkVersion(this.androidMinSdkVersion);
        config.setAndroidTargetSdkVersion(this.androidTargetSdkVersion);
        config.setAndroidManifest(this.androidManifest);
        if (this.getAndroidGradleTasks() != null) {
            String[] stringArray = this.getAndroidGradleTasks();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String variable = stringArray[i];
                config.getAndroidGradleTasks().add(variable);
            }
        }
        config.setAndroidGradleVersion(this.androidGradleVersion);
        config.setAndroidTestPackageName(this.androidTestPackageName);
        if (this.getIncreaseVariableValues() != null) {
            for (String variable : this.getIncreaseVariableValues()) {
                config.getIncreaseVariableValues().add(variable);
            }
        }
        return config;
    }
}

