/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config.parameters;

import de.dagere.kopeme.kieker.writer.WritingType;
import de.dagere.peass.config.KiekerConfig;
import java.util.LinkedHashSet;
import picocli.CommandLine;

public class KiekerConfigMixin {
    @CommandLine.Option(names={"-writeInterval", "--writeInterval"}, description={"Interval for KoPeMe-aggregated-writing (in milliseconds)"})
    public int writeInterval = 5000;
    @CommandLine.Option(names={"-notUseSourceInstrumentation", "--notUseSourceInstrumentation"}, description={"Not use source instrumentation (disabling enables AspectJ instrumentation)"})
    public boolean notUseSourceInstrumentation = false;
    @CommandLine.Option(names={"-useCircularQueue", "--useCircularQueue"}, description={"Use circular queue (default false - LinkedBlockingQueue is used)"})
    public boolean useCircularQueue = false;
    @CommandLine.Option(names={"-notUseSelectiveInstrumentation", "--notUseSelectiveInstrumentation"}, description={"Use selective instrumentation (only selected methods / classes are instrumented) - is activated by default is source instrumentation is activated"})
    public boolean notUseSelectiveInstrumentation = false;
    @CommandLine.Option(names={"-notUseAggregation", "--notUseAggregation"}, description={"Not use aggregation (aggregate the measured values immediately in the system under test, instead of summing them up after the execution). Is automatically disabled for regression test selection."})
    public boolean notUseAggregation = false;
    @CommandLine.Option(names={"-measureAdded", "--measureAdded"}, description={"Measure call tree nodes that have been added or removed in one commit (might lead to less accuracy of measurements)"})
    public boolean measureAdded = false;
    @CommandLine.Option(names={"-useExtraction", "--useExtraction"}, description={"Extract methods when using source instrumentation"})
    public boolean useExtraction = false;
    @CommandLine.Option(names={"-enableAdaptiveInstrumentation", "--enableAdaptiveInstrumentation"}, description={"Enable adaptive instrumentation (for performance comparison to AspectJ)"})
    public boolean enableAdaptiveInstrumentation = false;
    @CommandLine.Option(names={"-traceSizeInMb", "--traceSizeInMb"}, description={"Sets the maximum allowed trace size in Mb (bigger traces will be ignored by Peass)"})
    public long traceSizeInMb = 100L;
    @CommandLine.Option(names={"-kiekerQueueSize", "--kiekerQueueSize"}, description={"Sets the maximum queue size in Kieker (space is reserverd, consider increasing if queue entries are swallowed)"})
    public long kiekerQueueSize = 10000000L;
    @CommandLine.Option(names={"-onlyOneCallRecording", "--onlyOneCallRecording"}, description={"Only record calls once (ONLY allowed for regression test selection)"})
    public boolean onlyOneCallRecording = false;
    @CommandLine.Option(names={"-excludeForTracing", "--excludeForTracing"}, description={"Methods that are excluded for tracing in RTS and RCA (default: empty, excludes no method)"})
    protected String[] excludeForTracing;
    @CommandLine.Option(names={"-skipDefaultConstructor", "--skipDefaultConstructor"}, description={"Deactivates creation of the default constructor (required if Lombok is used)"})
    protected boolean skipDefaultConstructor = false;
    @CommandLine.Option(names={"-kiekerWaitTime", "--kiekerWaitTime"}, description={"Time that KoPeMe should wait until Kieker writing is finshed in seconds (default: 10)"})
    protected int kiekerWaitTime = 5;
    @CommandLine.Option(names={"-writingType", "--writingType"}, description={"Writing type for RCA data. BinaryAggregated writes results in a given amount of seconds, BinarySimple writes results every individual repetition. The latter might produce big amounts of data, hence, BinaryAggregated is the default currently"})
    protected WritingType writingType = WritingType.BinaryAggregated;
    @CommandLine.Option(names={"-disableKiekerKoPeMe", "--disableKiekerKoPeMe"}, description={"Disables the Kieker management by KoPeMe "})
    protected boolean disableKiekerKoPeMe;

    public int getWriteInterval() {
        return this.writeInterval;
    }

    public boolean isNotUseSourceInstrumentation() {
        return this.notUseSourceInstrumentation;
    }

    public boolean isUseCircularQueue() {
        return this.useCircularQueue;
    }

    public boolean isNotUseSelectiveInstrumentation() {
        return this.notUseSelectiveInstrumentation;
    }

    public boolean isNotUseAggregation() {
        return this.notUseAggregation;
    }

    public boolean isMeasureAdded() {
        return this.measureAdded;
    }

    public boolean isUseExtraction() {
        return this.useExtraction;
    }

    public boolean isEnableAdaptiveInstrumentation() {
        return this.enableAdaptiveInstrumentation;
    }

    public long getTraceSizeInMb() {
        return this.traceSizeInMb;
    }

    public void setTraceSizeInMb(long traceSizeInMb) {
        this.traceSizeInMb = traceSizeInMb;
    }

    public boolean isSkipDefaultConstructor() {
        return this.skipDefaultConstructor;
    }

    public void setSkipDefaultConstructor(boolean skipDefaultConstructor) {
        this.skipDefaultConstructor = skipDefaultConstructor;
    }

    public int getKiekerWaitTime() {
        return this.kiekerWaitTime;
    }

    public void setKiekerWaitTime(int kiekerWaitTime) {
        this.kiekerWaitTime = kiekerWaitTime;
    }

    public void setDisableKiekerKoPeMe(boolean disableKiekerKoPeMe) {
        this.disableKiekerKoPeMe = disableKiekerKoPeMe;
    }

    public boolean isDisableKiekerKoPeMe() {
        return this.disableKiekerKoPeMe;
    }

    public KiekerConfig getKiekerConfig() {
        KiekerConfig kiekerConfig = new KiekerConfig(true);
        kiekerConfig.setUseCircularQueue(this.useCircularQueue);
        kiekerConfig.setUseSelectiveInstrumentation(!this.notUseSelectiveInstrumentation);
        kiekerConfig.setUseAggregation(!this.notUseAggregation);
        kiekerConfig.setMeasureAdded(this.measureAdded);
        kiekerConfig.setExtractMethod(this.useExtraction);
        kiekerConfig.setAdaptiveInstrumentation(this.enableAdaptiveInstrumentation);
        kiekerConfig.setUseSourceInstrumentation(!this.notUseSourceInstrumentation);
        kiekerConfig.setKiekerQueueSize(this.kiekerQueueSize);
        kiekerConfig.setTraceSizeInMb(this.traceSizeInMb);
        kiekerConfig.setOnlyOneCallRecording(this.onlyOneCallRecording);
        kiekerConfig.setCreateDefaultConstructor(!this.skipDefaultConstructor);
        kiekerConfig.setWritingType(this.writingType);
        if (this.excludeForTracing != null) {
            LinkedHashSet<String> excludedForTracing = new LinkedHashSet<String>();
            for (String exclude : this.excludeForTracing) {
                excludedForTracing.add(exclude);
            }
            kiekerConfig.setExcludeForTracing(excludedForTracing);
        }
        kiekerConfig.setDisableKiekerKoPeMe(this.disableKiekerKoPeMe);
        kiekerConfig.check();
        return kiekerConfig;
    }
}

