/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config.parameters;

import de.dagere.peass.config.MeasurementStrategy;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import picocli.CommandLine;

public class MeasurementConfigurationMixin {
    public static final int DEFAULT_VMS = 30;
    public static final int DEFAULT_ITERATIONS = 5;
    public static final int DEFAULT_WARMUP = 5;
    public static final int DEFAULT_MAX_LOGSIZE_IN_MB = 100;
    public static final int DEFAULT_REPETITIONS = 1000000;
    public static final long DEFAULT_TIMEOUT = 5L;
    @CommandLine.Option(names={"-vms", "--vms"}, description={"Number of VMs to start"})
    int vms = 30;
    @CommandLine.Option(names={"-iterations", "--iterations"}, description={"Number of iterations"})
    int iterations = 5;
    @CommandLine.Option(names={"-warmup", "--warmup"}, description={"Number of warmup iterations"})
    int warmup = 5;
    @CommandLine.Option(names={"-repetitions", "--repetitions"}, description={"Number of repetitions (executions of the workload inside of one iteration)"})
    int repetitions = 1000000;
    @CommandLine.Option(names={"-processTimeout", "--processTimeout"}, description={"Timeout that the overall measurement process has - if one VM measurement takes so long that this timeout will be hit, the overall process is stopped (only recommended for calibration runs)"})
    protected long processTimeout = 5L;
    @CommandLine.Option(names={"-maxLogSizeInMb", "--maxLogSizeInMb"}, description={"Maximum log size in MB"})
    int maxLogSizeInMb = 100;
    @CommandLine.Option(names={"-duration", "--duration"}, description={"Which duration to use - if duration is specified, warmup and iterations are ignored"})
    int duration = 0;
    @CommandLine.Option(names={"-useKieker", "--useKieker", "-usekieker", "--usekieker"}, description={"Whether Kieker should be used"})
    boolean useKieker = false;
    @CommandLine.Option(names={"-useGC", "--useGC"}, description={"Do execute GC before each iteration (default false)"})
    public boolean useGC = false;
    @CommandLine.Option(names={"-earlyStop", "--earlyStop"}, description={"Whether to stop early (i.e. execute VMs until type 1 and type 2 error are met)"})
    protected boolean earlyStop = false;
    @CommandLine.Option(names={"-saveKieker", "--saveKieker"}, description={"Save no kieker results in order to use less space - default false"})
    private boolean saveNothing = false;
    @CommandLine.Option(names={"-record", "--record"}, description={"Kieker Record type to use for monitoring "})
    protected AllowedKiekerRecord record = AllowedKiekerRecord.DURATION;
    @CommandLine.Option(names={"-measurementStrategy", "--measurementStrategy"}, description={"Measurement strategy (Default: PARALLEL) "})
    protected MeasurementStrategy measurementStrategy = MeasurementStrategy.PARALLEL;
    @CommandLine.Option(names={"-directlyMeasureKieker", "--directlyMeasureKieker"}, description={"Activates measurement via Kieker instead KoPeMe (only useful it repetitions = 1 and a test runner contains huge warmup)"})
    protected boolean directlyMeasureKieker = false;

    public int getVms() {
        return this.vms;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public boolean isSaveNothing() {
        return this.saveNothing;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public boolean isUseKieker() {
        return this.useKieker;
    }

    public boolean isUseGC() {
        return this.useGC;
    }

    public boolean isEarlyStop() {
        return this.earlyStop;
    }

    public void setVms(int vms) {
        this.vms = vms;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setWarmup(int warmup) {
        this.warmup = warmup;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
    }

    public void setMaxLogSizeInMb(int maxLogSizeInMb) {
        this.maxLogSizeInMb = maxLogSizeInMb;
    }

    public int getMaxLogSizeInMb() {
        return this.maxLogSizeInMb;
    }

    public void setUseKieker(boolean useKieker) {
        this.useKieker = useKieker;
    }

    public void setUseGC(boolean useGC) {
        this.useGC = useGC;
    }

    public void setEarlyStop(boolean earlyStop) {
        this.earlyStop = earlyStop;
    }

    public AllowedKiekerRecord getRecord() {
        return this.record;
    }

    public void setRecord(AllowedKiekerRecord record) {
        this.record = record;
    }

    public void setMeasurementStrategy(MeasurementStrategy measurementStrategy) {
        this.measurementStrategy = measurementStrategy;
    }

    public MeasurementStrategy getMeasurementStrategy() {
        return this.measurementStrategy;
    }

    public void setDirectlyMeasureKieker(boolean directlyMeasureKieker) {
        this.directlyMeasureKieker = directlyMeasureKieker;
    }

    public boolean isDirectlyMeasureKieker() {
        return this.directlyMeasureKieker;
    }
}

