/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config.parameters;

import de.dagere.peass.config.StatisticalTests;
import de.dagere.peass.config.StatisticsConfig;
import picocli.CommandLine;

public class StatisticsConfigMixin {
    public static final double PEASS_DEFAULT_TYPE_1_ERROR = 0.01;
    public static final double PEASS_DEFAULT_TYPE_2_ERROR = 0.01;
    @CommandLine.Option(names={"-outlierFactor", "--outlierFactor"}, description={"Whether outliers should be removed with z-score higher than the given value"})
    private double outlierFactor = 3.29;
    @CommandLine.Option(names={"-maximumRelativeDeviation", "--maximumRelativeDeviation"}, description={"Significance tests tend to not work on non-standard distributions; if a maximum relative deviation is set, all measurements having higher relative deviation are ignored."})
    private double maximumRelativeDeviation = Double.MAX_VALUE;
    @CommandLine.Option(names={"-type1error", "--type1error"}, description={"Type 1 error of t-test/false positive rate, i.e. probability of considering measurements unequal when they are equal"})
    public double type1error = 0.01;
    @CommandLine.Option(names={"-type2error", "--type2error"}, description={"Type 2 error of *agnostic* t-test/false negative rate, i.e. probability of considering measurements equal when they are unequal"})
    protected double type2error = 0.01;
    @CommandLine.Option(names={"-statisticTest", "--statisticTest"}, description={"Statistic test to use for comparison, default t-test"}, required=false)
    private StatisticalTests statisticTest = StatisticalTests.MANN_WHITNEY_TEST;

    public double getOutlierFactor() {
        return this.outlierFactor;
    }

    public void setOutlierFactor(double outlierFactor) {
        this.outlierFactor = outlierFactor;
    }

    public double getMaximumRelativeDeviation() {
        return this.maximumRelativeDeviation;
    }

    public void setMaximumRelativeDeviation(double maximumRelativeDeviation) {
        this.maximumRelativeDeviation = maximumRelativeDeviation;
    }

    public double getType1error() {
        return this.type1error;
    }

    public void setType1error(double type1error) {
        this.type1error = type1error;
    }

    public double getType2error() {
        return this.type2error;
    }

    public void setType2error(double type2error) {
        this.type2error = type2error;
    }

    public StatisticalTests getStatisticTest() {
        return this.statisticTest;
    }

    public void setStatisticTest(StatisticalTests statisticTest) {
        this.statisticTest = statisticTest;
    }

    public StatisticsConfig getStasticsConfig() {
        StatisticsConfig config = new StatisticsConfig();
        config.setType1error(this.getType1error());
        config.setType2error(this.getType2error());
        config.setStatisticTest(this.getStatisticTest());
        config.setOutlierFactor(this.getOutlierFactor());
        config.setMaximumRelativeDeviation(this.getMaximumRelativeDeviation());
        return config;
    }
}

