/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.config.parameters;

import de.dagere.peass.config.TestSelectionConfig;
import java.io.File;
import picocli.CommandLine;

public class TestSelectionConfigMixin {
    @CommandLine.Option(names={"-folder", "--folder"}, description={"Folder that should be analyzed"}, required=true)
    private File projectFolder;
    @CommandLine.Option(names={"-out", "--out"}, description={"Folder for results"})
    private File resultBaseFolder = new File("results");
    @CommandLine.Option(names={"-threads", "--threads"}, description={"Number of parallel threads for analysis, default 2"})
    private int threads = 2;
    @CommandLine.Option(names={"-doNotUpdateDependencies", "--doNotUpdateDependencies"}, description={"Disable updating of dependencies. This will make results for more than one version unusable, but increase dependency creation speed."})
    public boolean doNotUpdateDependencies = false;
    @CommandLine.Option(names={"-doNotGenerateTraces", "--doNotGenerateTraces"}, description={"Disable generation of traces (and thereby trace-diffs). Is false by default, but will be activated automatically if --doNotUpdateDependencies is set."})
    public boolean doNotGenerateTraces = false;
    @CommandLine.Option(names={"-skipProcessSuccessRuns", "--skipProcessSuccessRuns"}, description={"Skips the process success run. "})
    public boolean skipProcessSuccessRuns = false;
    @CommandLine.Option(names={"-doNotGenerateCoverageSelection", "--doNotGenerateCoverageSelection"}, description={"Disables coverage selection. Is false by default, but will be activated automatically if --doNotGenerateCoverageSelection is set."})
    public boolean doNotGenerateCoverageSelection = false;
    @CommandLine.Option(names={"-doNotGenerateTwiceExecutability", "--doNotGenerateTwiceExecutability"}, description={"Disables checking, whether tests are executable twice (need some time, but may sort out tests that are not measurable)"})
    public boolean doNotGenerateTwiceExecutability = false;
    @CommandLine.Option(names={"-doNotGenerateProperties", "--doNotGenerateProperties"}, description={"Disables properties generation. By default, properties will be generated."})
    public boolean doNotGenerateProperties = false;
    @CommandLine.Option(names={"-dontWriteAsZip", "--dontWriteAsZip"}, description={"Write traces as txt files (ZIP saves HDD spaces, but slows down processing)"})
    public boolean dontWriteAsZip = false;

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getResultBaseFolder() {
        return this.resultBaseFolder;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setDoNotUpdateDependencies(boolean doNotUpdateDependencies) {
        this.doNotUpdateDependencies = doNotUpdateDependencies;
    }

    public boolean isDoNotUpdateDependencies() {
        return this.doNotUpdateDependencies;
    }

    public boolean isDoNotGenerateProperties() {
        return this.doNotGenerateProperties;
    }

    public TestSelectionConfig getDependencyConfig() {
        if (this.doNotUpdateDependencies) {
            this.doNotGenerateCoverageSelection = true;
            this.doNotGenerateTraces = true;
        }
        boolean generateTraces = !this.doNotGenerateTraces;
        boolean generateCoverageSelection = !this.doNotGenerateCoverageSelection;
        boolean generateTwiceExecutability = !this.doNotGenerateTwiceExecutability;
        return new TestSelectionConfig(this.threads, this.doNotUpdateDependencies, generateTraces, generateCoverageSelection, generateTwiceExecutability, this.skipProcessSuccessRuns, !this.dontWriteAsZip);
    }
}

