/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.debugtools;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependency.persistence.InitialCallList;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CompareDependencies {
    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        File oldDependenciesFile = new File(args[0]);
        File newDependenciesFile = new File(args[1]);
        StaticTestSelection oldDependencies = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(oldDependenciesFile, StaticTestSelection.class);
        StaticTestSelection newDependencies = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(newDependenciesFile, StaticTestSelection.class);
        int addedCount = 0;
        int missingCount = 0;
        LinkedList<TestMethodCall> notFoundNewDependencies = new LinkedList<TestMethodCall>();
        notFoundNewDependencies.addAll(newDependencies.getInitialcommit().getInitialDependencies().keySet());
        for (Map.Entry<TestMethodCall, InitialCallList> entry : oldDependencies.getInitialcommit().getInitialDependencies().entrySet()) {
            for (Map.Entry<TestMethodCall, InitialCallList> initialDepNew : newDependencies.getInitialcommit().getInitialDependencies().entrySet()) {
                if (!initialDepNew.getKey().equals((Object)entry.getKey())) continue;
                List<String> missing = CompareDependencies.getDifference(entry.getValue(), initialDepNew.getValue());
                List<String> added = CompareDependencies.getDifference(initialDepNew.getValue(), entry.getValue());
                if (missing.size() > 0 || added.size() > 0) {
                    System.out.println("Test: " + String.valueOf(initialDepNew.getKey()) + "(" + initialDepNew.getValue().getEntities().size() + " " + entry.getValue().getEntities().size() + ")");
                    System.out.println("Missing: " + String.valueOf(missing));
                    System.out.println("Added: " + String.valueOf(added));
                    addedCount += added.size();
                    missingCount += missing.size();
                }
                notFoundNewDependencies.remove(initialDepNew.getKey());
            }
        }
        System.out.println("Added: " + addedCount + " Missing: " + missingCount);
        System.out.println("Missing testcases: " + notFoundNewDependencies.size());
        for (TestCase testCase : notFoundNewDependencies) {
            System.out.println("Missing: " + testCase.toString());
        }
    }

    private static List<String> getDifference(InitialCallList initialDepOld, InitialCallList initialDepNew) {
        LinkedList<String> missing = new LinkedList<String>();
        for (MethodCall clazz : initialDepOld.getEntities()) {
            missing.add(clazz.toString());
        }
        for (MethodCall clazz : initialDepNew.getEntities()) {
            missing.remove(clazz.toString());
        }
        Iterator it = missing.iterator();
        while (it.hasNext()) {
            String current = (String)it.next();
            if (!current.endsWith("getMaximalTime") && !current.endsWith("getExecutionTimes") && !current.endsWith("getWarmupExecutions")) continue;
            it.remove();
        }
        return missing;
    }
}

