/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.debugtools;

import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import picocli.CommandLine;

public class DetectUncoveredChanges
implements Callable<Void> {
    @CommandLine.Option(names={"-staticSelectionFiles", "--staticSelectionFiles"}, description={"Files from the same project that should be analyzed"}, required=true)
    public File[] staticSelectionFiles;

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new DetectUncoveredChanges());
        commandLine.execute(args);
    }

    @Override
    public Void call() throws Exception {
        LinkedList<String> commits = new LinkedList<String>();
        StaticTestSelection[] selections = new StaticTestSelection[this.staticSelectionFiles.length];
        for (int i = 0; i < this.staticSelectionFiles.length; ++i) {
            File staticSelectionFile = this.staticSelectionFiles[i];
            selections[i] = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(staticSelectionFile, StaticTestSelection.class);
            for (String commit : selections[i].getCommits().keySet()) {
                commits.add(commit);
            }
        }
        int uncoveredCommits = 0;
        int uncoveredChanges = 0;
        int coveredCommits = 0;
        int coveredChanges = 0;
        for (String commit : commits) {
            Set<Type> changes = selections[0].getCommits().get(commit).getChangedClazzes().keySet();
            boolean anyUncoveredCommit = false;
            boolean anyCoveredCommit = false;
            for (Type entity : changes) {
                boolean covered = this.isEntityCovered(selections, commit, entity);
                if (!covered) {
                    System.out.println("Not covered in " + commit + ": " + String.valueOf(entity));
                    anyUncoveredCommit = true;
                    ++uncoveredChanges;
                    continue;
                }
                anyCoveredCommit = true;
                ++coveredChanges;
            }
            if (anyUncoveredCommit) {
                ++uncoveredCommits;
            }
            if (!anyCoveredCommit) continue;
            ++coveredCommits;
        }
        System.out.println("Uncovered commits: " + uncoveredCommits + " (" + uncoveredChanges + ")");
        System.out.println("Covered commits: " + coveredCommits + " (" + coveredChanges + ")");
        return null;
    }

    private boolean isEntityCovered(StaticTestSelection[] selections, String commit, Type entity) {
        boolean covered = false;
        for (StaticTestSelection selection : selections) {
            TestSet testSet;
            CommitStaticSelection commitStaticSelection = selection.getCommits().get(commit);
            if (commitStaticSelection == null || (testSet = commitStaticSelection.getChangedClazzes().get(entity)) == null || testSet.getTestMethods().size() <= 0) continue;
            covered = true;
        }
        return covered;
    }
}

