/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.debugtools;

import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.config.parameters.TestSelectionConfigMixin;
import de.dagere.peass.dependency.parallel.PartialSelectionResultsMerger;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.vcs.CommitUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import picocli.CommandLine;

public class OnlyMergeTestSelection
implements Callable<Void> {
    @CommandLine.Mixin
    private TestSelectionConfigMixin config;
    @CommandLine.Mixin
    private ExecutionConfigMixin executionConfigMixin;
    @CommandLine.Option(names={"-baseFolder", "--baseFolder"}, description={"Folder of the results that should be merged"}, required=true)
    private File baseFolder;
    @CommandLine.Option(names={"-mergedFolder", "--mergedFolder"}, description={"Folder of the merged results"}, required=true)
    private File mergedFolder;

    public static void main(String[] args) {
        try {
            CommandLine commandLine = new CommandLine((Object)new OnlyMergeTestSelection());
            commandLine.execute(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Void call() throws Exception {
        File projectFolder = this.config.getProjectFolder();
        List<String> commits = CommitUtil.getGitCommits(this.executionConfigMixin.getStartcommit(), this.executionConfigMixin.getEndcommit(), projectFolder, this.executionConfigMixin.isLinearizeHistory());
        CommitComparatorInstance instance = new CommitComparatorInstance(commits);
        if (this.baseFolder == null) {
            File[] files = this.config.getResultBaseFolder().listFiles((FilenameFilter)new WildcardFileFilter("staticTestSelection_*.json"));
            PartialSelectionResultsMerger.mergePartFiles(new File(this.config.getResultBaseFolder(), "staticTestSelection_merged.json"), files, instance);
        } else {
            File[] resultsFolders = this.findResultsFolder();
            ResultsFolders[] outFiles = new ResultsFolders[resultsFolders.length];
            for (int i = 0; i < outFiles.length; ++i) {
                outFiles[i] = new ResultsFolders(resultsFolders[i], projectFolder.getName());
            }
            ResultsFolders mergedFolders = new ResultsFolders(this.mergedFolder, projectFolder.getName());
            PartialSelectionResultsMerger.mergePartialData(instance, outFiles, mergedFolders);
        }
        return null;
    }

    private File[] findResultsFolder() {
        File[] resultsFolders = this.baseFolder.listFiles();
        ArrayList result = new ArrayList();
        for (int i = 0; i < resultsFolders.length; ++i) {
            if (!resultsFolders[i].isDirectory()) continue;
            try (Stream<Path> path = Files.walk(resultsFolders[i].toPath(), new FileVisitOption[0]);){
                path.filter(f -> f.getFileName().toString().startsWith("staticTestSelection")).forEach(f -> result.add(f.getParent().toFile()));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("staticTestSelection was not found in result folder", e);
            }
        }
        return result.toArray(new File[result.size()]);
    }
}

