/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.debugtools;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.config.parameters.KiekerConfigMixin;
import de.dagere.peass.config.parameters.TestSelectionConfigMixin;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependency.reader.CommitKeeper;
import de.dagere.peass.dependency.reader.DependencyReader;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.dependencyprocessors.VersionComparator;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.CommitIterator;
import de.dagere.peass.vcs.CommitIteratorGit;
import de.dagere.peass.vcs.CommitUtil;
import de.dagere.peass.vcs.GitUtils;
import de.dagere.peass.vcs.VersionControlSystem;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

public class RegressionTestSelectionContinueStarter
implements Callable<Void> {
    private static final Logger LOG = LogManager.getLogger(RegressionTestSelectionContinueStarter.class);
    @CommandLine.Mixin
    private TestSelectionConfigMixin config;
    @CommandLine.Mixin
    private KiekerConfigMixin kiekerConfigMixin;
    @CommandLine.Mixin
    private ExecutionConfigMixin executionConfigMixin;
    @CommandLine.Option(names={"-staticSelectionFile", "--staticSelectionFile"}, description={"Path to the staticSelectionFile"})
    private File staticSelectionFile;

    public static void main(String[] args) {
        try {
            CommandLine commandLine = new CommandLine((Object)new RegressionTestSelectionContinueStarter());
            commandLine.execute(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Void call() throws Exception {
        File projectFolder = this.config.getProjectFolder();
        if (!projectFolder.exists()) {
            throw new RuntimeException("Folder " + projectFolder.getAbsolutePath() + " does not exist.");
        }
        File dependencyFileIn = this.getDependencyInFile();
        StaticTestSelection dependencies = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(dependencyFileIn, StaticTestSelection.class);
        CommitComparatorInstance comparator = new CommitComparatorInstance(GitUtils.getCommits(projectFolder, false, this.executionConfigMixin.isLinearizeHistory()));
        VersionComparator.setVersions(GitUtils.getCommits(projectFolder, false, this.executionConfigMixin.isLinearizeHistory()));
        String previousCommit = RegressionTestSelectionContinueStarter.getPreviousCommit(this.executionConfigMixin.getStartcommit(), projectFolder, dependencies, comparator);
        long timeout = this.executionConfigMixin.getTimeout();
        LOG.debug("Lese {}", (Object)projectFolder.getAbsolutePath());
        VersionControlSystem vcs = VersionControlSystem.getVersionControlSystem(projectFolder);
        ResultsFolders resultsFolders = new ResultsFolders(this.config.getResultBaseFolder(), this.config.getProjectFolder().getName() + "_out");
        DependencyReader reader = this.createReader(this.config, resultsFolders, dependencies, previousCommit, timeout, vcs);
        reader.readCompletedCommits(dependencies, comparator);
        reader.readDependencies();
        return null;
    }

    private File getDependencyInFile() {
        File dependencyFileIn = this.staticSelectionFile != null ? this.staticSelectionFile : new File(this.config.getResultBaseFolder(), "staticTestSelection_" + this.config.getProjectFolder().getName() + "_continue.json");
        return dependencyFileIn;
    }

    static String getPreviousCommit(String startcommit, File projectFolder, StaticTestSelection dependencies, CommitComparatorInstance comparator) {
        String previousCommit;
        String[] commitNames = dependencies.getCommitNames();
        if (startcommit != null) {
            String commitAfterStartCommit;
            int startCommitIndex = Arrays.asList(commitNames).indexOf(startcommit);
            previousCommit = commitAfterStartCommit = commitNames[startCommitIndex - 1];
            RegressionTestSelectionContinueStarter.truncateCommits(startcommit, dependencies.getCommits(), comparator);
        } else {
            String newestCommit;
            previousCommit = newestCommit = commitNames[commitNames.length - 1];
        }
        return previousCommit;
    }

    DependencyReader createReader(TestSelectionConfigMixin config, ResultsFolders resultsFolders, StaticTestSelection dependencies, String previousCommit, long timeout, VersionControlSystem vcs) {
        if (!vcs.equals((Object)VersionControlSystem.GIT)) {
            if (vcs.equals((Object)VersionControlSystem.SVN)) {
                throw new RuntimeException("SVN not supported currently.");
            }
            throw new RuntimeException("Unknown version control system");
        }
        CommitIterator iterator = this.createIterator(config, previousCommit);
        ExecutionConfig executionConfig = this.executionConfigMixin.getExecutionConfig();
        DependencyReader reader = new DependencyReader(config.getDependencyConfig(), new PeassFolders(config.getProjectFolder()), resultsFolders, dependencies.getUrl(), iterator, new CommitKeeper(new File(resultsFolders.getStaticTestSelectionFile().getParentFile(), "nochanges.json")), executionConfig, this.kiekerConfigMixin.getKiekerConfig(), new EnvironmentVariables());
        iterator.goTo0thCommit();
        return reader;
    }

    private CommitIterator createIterator(TestSelectionConfigMixin config, String previousCommit) {
        List<String> commits = CommitUtil.getGitCommits(this.executionConfigMixin.getStartcommit(), this.executionConfigMixin.getEndcommit(), config.getProjectFolder(), this.executionConfigMixin.isLinearizeHistory());
        commits.add(0, previousCommit);
        CommitIteratorGit iterator = new CommitIteratorGit(config.getProjectFolder(), commits, previousCommit);
        return iterator;
    }

    public static void truncateCommits(String startcommit, Map<String, CommitStaticSelection> commits, CommitComparatorInstance comparator) {
        Iterator<Map.Entry<String, CommitStaticSelection>> it = commits.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, CommitStaticSelection> commit = it.next();
            if (!comparator.isBefore(startcommit, commit.getKey()) && !commit.getKey().equals(startcommit)) continue;
            LOG.trace("Remove: " + commit.getKey() + " " + comparator.isBefore(startcommit, commit.getKey()));
            it.remove();
        }
    }
}

