/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency;

import de.dagere.nodeDiffDetector.config.FolderConfig;
import de.dagere.nodeDiffDetector.config.SourceCodeFolders;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.diffDetection.ChangeDetector;
import de.dagere.nodeDiffDetector.diffDetection.ClazzChangeData;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.analysis.data.CommitDiff;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.vcs.CommitIterator;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeManager {
    private static final Logger LOG = LogManager.getLogger(ChangeManager.class);
    private final PeassFolders folders;
    private final CommitIterator iterator;
    private final ExecutionConfig config;
    private final TestExecutor testExecutor;

    public ChangeManager(PeassFolders folders, CommitIterator iterator, ExecutionConfig config, TestExecutor testExecutor) {
        this.folders = folders;
        this.iterator = iterator;
        this.config = config;
        this.testExecutor = testExecutor;
    }

    private List<Type> getChangedClasses(String lastCommit) throws FileNotFoundException, IOException {
        List<File> moduleFiles = this.testExecutor.getModules().getModules();
        CommitDiff diff = this.iterator.getChangedClasses(this.folders.getProjectFolder(), moduleFiles, lastCommit, this.config);
        LOG.info("Changed classes: " + diff.getChangedClasses().size());
        return diff.getChangedClasses();
    }

    public void saveOldClasses() {
        try {
            LOG.debug("Saving old classes");
            if (this.folders.getOldSources().exists()) {
                FileUtils.deleteDirectory((File)this.folders.getOldSources());
            }
            this.folders.getOldSources().mkdir();
            for (File module : this.testExecutor.getModules().getModules()) {
                this.saveModule(module);
            }
        }
        catch (IOException e) {
            LOG.debug("Could not save (all) old files");
            e.printStackTrace();
        }
    }

    private void saveModule(File module) throws IOException {
        for (String path : this.config.getAllClazzFolders()) {
            this.savePath(module, path);
        }
    }

    private void savePath(File module, String path) throws IOException {
        File srcDir = new File(module, path);
        if (srcDir.exists()) {
            File destModuleDir;
            if (!module.equals(this.folders.getProjectFolder())) {
                String relative = this.folders.getProjectFolder().toURI().relativize(module.toURI()).getPath();
                destModuleDir = new File(this.folders.getOldSources(), relative + File.separator + path);
            } else {
                destModuleDir = new File(this.folders.getOldSources(), path);
            }
            destModuleDir.getParentFile().mkdirs();
            LOG.debug("Copying from {} to {}", (Object)srcDir.getAbsolutePath(), (Object)destModuleDir.getAbsolutePath());
            FileUtils.copyDirectory((File)srcDir, (File)destModuleDir, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.canRead() && pathname.canWrite();
                }
            });
        }
    }

    public Map<Type, ClazzChangeData> getChanges(String commit1, String commit2) {
        GitUtils.goToCommit(commit1, this.folders.getProjectFolder());
        this.saveOldClasses();
        GitUtils.goToCommit(commit2, this.folders.getProjectFolder());
        return this.getChanges(commit1);
    }

    public Map<Type, ClazzChangeData> getChanges(String lastRunningVersion) {
        TreeMap<Type, ClazzChangeData> changedClassesMethods = new TreeMap<Type, ClazzChangeData>();
        try {
            List<Type> changedClasses = this.getChangedClasses(lastRunningVersion);
            LOG.debug("Before Cleaning: {}", changedClasses);
            if (this.folders.getOldSources().exists()) {
                ChangeDetector detector = new ChangeDetector((FolderConfig)this.config, (SourceCodeFolders)this.folders);
                Iterator<Type> clazzIterator = changedClasses.iterator();
                while (clazzIterator.hasNext()) {
                    detector.compareClazz(changedClassesMethods, clazzIterator);
                }
            } else {
                LOG.info("There is no folder for old files");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        LOG.debug("After cleaning: {}", changedClassesMethods);
        return changedClassesMethods;
    }
}

