/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.dependency.KiekerResultManager;
import de.dagere.peass.dependency.TestFinder;
import de.dagere.peass.dependency.analysis.CalledMethodLoader;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.CalledMethods;
import de.dagere.peass.dependency.analysis.data.TestDependencies;
import de.dagere.peass.dependency.analysis.data.TestExistenceChanges;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.traces.KiekerFolderUtil;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DependencyManager
extends KiekerResultManager {
    private static final Logger LOG = LogManager.getLogger(DependencyManager.class);
    private final TestDependencies dependencies = new TestDependencies();
    private long deleteFolderSize;

    public DependencyManager(PeassFolders folders, ExecutionConfig executionConfig, KiekerConfig kiekerConfig, EnvironmentVariables env) {
        super(folders, executionConfig, kiekerConfig, env);
        this.deleteFolderSize = kiekerConfig.getTraceSizeInMb() * 10L;
    }

    public DependencyManager(TestExecutor executor, PeassFolders folders) {
        super(executor, folders);
    }

    public TestDependencies getDependencyMap() {
        return this.dependencies;
    }

    public void setDeleteFolderSize(int deleteFolderSize) {
        this.deleteFolderSize = deleteFolderSize;
    }

    public boolean initialyGetTraces(String commit) throws IOException {
        if (this.folders.getTempMeasurementFolder().exists()) {
            FileUtils.deleteDirectory((File)this.folders.getTempMeasurementFolder());
        }
        ModuleClassMapping mapping = new ModuleClassMapping(this.executor);
        this.executor.loadClasses();
        TestFinder testFinder = new TestFinder(this.executor);
        TestSet tests = testFinder.findIncludedTests(mapping);
        if (tests.getTestMethods().isEmpty()) {
            LOG.error("No tests were selected - maybe the tests are all disabled or no tests meets the pattern");
            return false;
        }
        this.runTraceTests(tests, commit);
        if (this.folders.getTempMeasurementFolder().exists()) {
            return this.readInitialResultFiles(mapping);
        }
        return this.printErrors();
    }

    private boolean printErrors() throws IOException {
        try {
            boolean sourceFound = false;
            sourceFound = this.searchTestFiles(sourceFound);
            if (sourceFound) {
                LOG.debug("No result data available - error occured?");
                return false;
            }
            LOG.debug("No result data available, but no test-classes existing - so it is ok.");
            return true;
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean searchTestFiles(boolean sourceFound) throws IOException, XmlPullParserException {
        for (File module : this.executor.getModules().getModules()) {
            Collection javaTestFiles;
            File testSourceFolder = new File(module, "src" + File.separator + "test");
            if (!testSourceFolder.exists() || (javaTestFiles = FileUtils.listFiles((File)testSourceFolder, (IOFileFilter)new WildcardFileFilter("*test*.java", IOCase.INSENSITIVE), (IOFileFilter)TrueFileFilter.INSTANCE)).size() <= 0) continue;
            sourceFound = true;
        }
        return sourceFound;
    }

    private boolean readInitialResultFiles(ModuleClassMapping mapping) {
        Collection xmlFiles = FileUtils.listFiles((File)this.folders.getTempMeasurementFolder(), (IOFileFilter)new WildcardFileFilter("*.json"), (IOFileFilter)TrueFileFilter.INSTANCE);
        LOG.debug("Initial test execution finished, starting result collection, analyzing {} files", (Object)xmlFiles.size());
        for (File testResultFile : xmlFiles) {
            File parent = testResultFile.getParentFile();
            String testClassName = parent.getName();
            String testMethodName = testResultFile.getName().substring(0, testResultFile.getName().length() - ".json".length());
            String moduleOfClass = mapping.getModuleOfClass(testClassName);
            if (moduleOfClass == null) {
                throw new RuntimeException("Module of class " + testClassName + " is null");
            }
            TestMethodCall testcase = new TestMethodCall(testClassName, testMethodName, moduleOfClass);
            this.updateDependenciesOnce(testcase, parent, mapping);
        }
        LOG.debug("Result collection finished");
        return true;
    }

    public void cleanResultFolder() {
        File movedInitialResults = new File(this.folders.getTempMeasurementFolder().getParentFile(), "initialresults_kieker");
        if (movedInitialResults.exists()) {
            try {
                LOG.info("Deleting old initialresults");
                FileUtils.deleteDirectory((File)movedInitialResults);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileUtils.moveDirectory((File)this.folders.getTempMeasurementFolder(), (File)movedInitialResults);
        }
        catch (IOException e) {
            LOG.info("Moving did not succeed");
            LOG.info("Error: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        if (movedInitialResults.exists()) {
            for (File classFolder : movedInitialResults.listFiles()) {
                LOG.debug("Cleaning {}", (Object)classFolder.getAbsolutePath());
                if (!classFolder.isDirectory()) continue;
                this.cleanFolderAboveSize(classFolder, this.deleteFolderSize);
            }
        } else {
            LOG.error("Initial result folder did not exist");
        }
    }

    public void updateDependenciesOnce(TestMethodCall testcase, File parent, ModuleClassMapping mapping) {
        LOG.debug("Parent: " + String.valueOf(parent));
        File moduleResultsFolder = KiekerFolderUtil.getModuleResultFolder(this.folders, (TestCase)testcase);
        File[] kiekerResultFolders = KiekerFolderUtil.getClazzMethodFolder(testcase, moduleResultsFolder);
        if (kiekerResultFolders == null) {
            LOG.error("No kieker folder found: " + String.valueOf(parent));
            return;
        }
        Map<Type, Set<String>> allCalledClasses = this.getCalledMethods(mapping, kiekerResultFolders);
        this.removeNotExistingClazzes(allCalledClasses);
        for (Type clazz : allCalledClasses.keySet()) {
            if (clazz.getModule() != null) continue;
            throw new RuntimeException("Class " + clazz.getJavaClazzName() + " has no module!");
        }
        LOG.debug("Test: {} ", (Object)testcase);
        LOG.debug("Dependencies: {}", (Object)allCalledClasses.size());
        boolean testExcluded = false;
        if (this.forbiddenMethodCalled(allCalledClasses)) {
            testExcluded = true;
            this.testTransformer.getConfig().getExecutionConfig().getExcludes().add(testcase.getExecutable());
        }
        if (this.getTraceSize(kiekerResultFolders) > this.testTransformer.getConfig().getKiekerConfig().getTraceSizeInMb()) {
            testExcluded = true;
        }
        if (!testExcluded) {
            this.dependencies.setDependencies(testcase, allCalledClasses);
        }
    }

    private boolean forbiddenMethodCalled(Map<Type, Set<String>> allCalledClasses) {
        List<String> forbiddenMethods = this.testTransformer.getConfig().getExecutionConfig().getForbiddenMethods();
        for (String forbiddenMethod : forbiddenMethods) {
            if (!this.traceContainsMethod(allCalledClasses, forbiddenMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean traceContainsMethod(Map<Type, Set<String>> allCalledClasses, String methodToFind) {
        String[] classAndMethod = methodToFind.split("#");
        for (Map.Entry<Type, Set<String>> calledClass : allCalledClasses.entrySet()) {
            Set<String> calledMethods;
            if (!calledClass.getKey().getClazz().equals(classAndMethod[0]) || !(calledMethods = calledClass.getValue()).contains(classAndMethod[1])) continue;
            return true;
        }
        return false;
    }

    private long getTraceSize(File[] kiekerResultFolders) {
        long overallSizeInMB = 0L;
        for (File kiekerResultFolder : kiekerResultFolders) {
            long size = FileUtils.sizeOfDirectory((File)kiekerResultFolder);
            long sizeInMB = size / 0x100000L;
            overallSizeInMB += sizeInMB;
            LOG.debug("Size: {} Folder: {}", (Object)sizeInMB, (Object)kiekerResultFolder);
        }
        return overallSizeInMB;
    }

    private Map<Type, Set<String>> getCalledMethods(ModuleClassMapping mapping, File[] kiekerResultFolders) {
        LinkedHashMap<Type, Set<String>> allCalledClasses = new LinkedHashMap<Type, Set<String>>();
        for (File kiekerResultFolder : kiekerResultFolders) {
            LOG.debug("Reading Kieker folder: {}", (Object)kiekerResultFolder.getAbsolutePath());
            CalledMethodLoader calledMethodLoader = new CalledMethodLoader(kiekerResultFolder, mapping, this.testTransformer.getConfig().getKiekerConfig());
            Map<Type, Set<String>> calledMethods = calledMethodLoader.getCalledMethods();
            for (Map.Entry<Type, Set<String>> calledMethod : calledMethods.entrySet()) {
                if (!allCalledClasses.containsKey(calledMethod.getKey())) {
                    allCalledClasses.put(calledMethod.getKey(), calledMethod.getValue());
                    continue;
                }
                Set alreadyKnownCalledClasses = (Set)allCalledClasses.get(calledMethod.getKey());
                alreadyKnownCalledClasses.addAll((Collection)calledMethod.getValue());
            }
        }
        return allCalledClasses;
    }

    private void removeNotExistingClazzes(Map<Type, Set<String>> calledClasses) {
        Iterator<Type> iterator = calledClasses.keySet().iterator();
        while (iterator.hasNext()) {
            Type entity = iterator.next();
            String wholeClassName = entity.getJavaClazzName();
            String outerClazzName = TypeFileFinder.getOuterClass((String)wholeClassName);
            LOG.trace("Testing: " + outerClazzName);
            if (!this.executor.getExistingClasses().contains(outerClazzName)) {
                iterator.remove();
                continue;
            }
            LOG.trace("Existing: " + outerClazzName);
        }
    }

    public TestExistenceChanges updateDependencies(TestSet testsToUpdate, ModuleClassMapping mapping) {
        Map<TestMethodCall, Map<Type, Set<String>>> oldDepdendencies = this.dependencies.getCopiedDependencies();
        for (Map.Entry<TestClazzCall, Set<String>> className : testsToUpdate.entrySet()) {
            for (String method : className.getValue()) {
                TestMethodCall entity = new TestMethodCall(className.getKey().getClazz(), method, className.getKey().getModule());
                this.dependencies.getDependencyMap().remove(entity);
            }
        }
        LOG.debug("Beginne Abh\u00e4ngigkeiten-Aktuallisierung f\u00fcr {} Klassen", (Object)testsToUpdate.getClasses().size());
        TestExistenceChanges changes = this.populateExistingTests(testsToUpdate, mapping, oldDepdendencies);
        this.findAddedTests(oldDepdendencies, changes);
        return changes;
    }

    private TestExistenceChanges populateExistingTests(TestSet testsToUpdate, ModuleClassMapping mapping, Map<TestMethodCall, Map<Type, Set<String>>> oldDepdendencies) {
        TestExistenceChanges changes = new TestExistenceChanges();
        for (Map.Entry<TestClazzCall, Set<String>> entry : testsToUpdate.entrySet()) {
            File testclazzFolder = this.getTestclazzFolder(entry);
            LOG.debug("Suche in {} Existiert: {} Ordner: {} Tests: {} ", (Object)testclazzFolder.getAbsolutePath(), (Object)testclazzFolder.exists(), (Object)testclazzFolder.isDirectory(), entry.getValue());
            if (testclazzFolder.exists()) {
                this.updateMethods(mapping, changes, entry, testclazzFolder);
                continue;
            }
            this.checkRemoved(oldDepdendencies, changes, entry, testclazzFolder);
        }
        return changes;
    }

    public File getTestclazzFolder(Map.Entry<TestClazzCall, Set<String>> entry) {
        File moduleResultFolder = KiekerFolderUtil.getModuleResultFolder(this.folders, (TestCase)entry.getKey());
        File testclazzFolder = new File(moduleResultFolder, entry.getKey().getClazz());
        return testclazzFolder;
    }

    void updateMethods(ModuleClassMapping mapping, TestExistenceChanges changes, Map.Entry<TestClazzCall, Set<String>> entry, File testclazzFolder) {
        TreeSet notFound = new TreeSet();
        notFound.addAll(entry.getValue());
        for (File testResultFile : testclazzFolder.listFiles((FileFilter)new WildcardFileFilter("*.json"))) {
            String testClassName2 = testResultFile.getParentFile().getName();
            if (!testClassName2.equals(entry.getKey().getClazz())) {
                LOG.error("Testclass " + entry.getKey().getClazz() + " != " + testClassName2);
            }
            File parent = testResultFile.getParentFile();
            String testMethodName = testResultFile.getName().substring(0, testResultFile.getName().length() - ".json".length());
            String module = mapping.getModuleOfClass(entry.getKey().getClazz());
            this.updateDependenciesOnce(new TestMethodCall(entry.getKey().getClazz(), testMethodName, module), parent, mapping);
            notFound.remove(testMethodName);
        }
        LOG.debug("Removed tests: {}", notFound);
        for (String testMethodName : notFound) {
            TestMethodCall entity = new TestMethodCall(entry.getKey().getClazz(), testMethodName, entry.getKey().getModule());
            this.dependencies.removeTest((TestCase)entity);
            changes.addRemovedTest((TestCase)new TestMethodCall(entry.getKey().getClazz(), testMethodName, entry.getKey().getModule()));
        }
    }

    void checkRemoved(Map<TestMethodCall, Map<Type, Set<String>>> oldDepdendencies, TestExistenceChanges changes, Map.Entry<TestClazzCall, Set<String>> entry, File testclazzFolder) {
        LOG.error("Testclass {} does not exist anymore or does not create results. Folder: {}", (Object)entry.getKey(), (Object)testclazzFolder);
        TestClazzCall testclass = new TestClazzCall(entry.getKey().getClazz(), entry.getKey().getModule());
        boolean oldContained = false;
        for (TestMethodCall oldTest : oldDepdendencies.keySet()) {
            if (!testclass.getClazz().equals(oldTest.getClazz()) || !testclass.getModule().equals(oldTest.getModule())) continue;
            oldContained = true;
        }
        if (oldContained) {
            changes.addRemovedTest((TestCase)testclass);
        } else {
            LOG.trace("Test was only added incorrect (was not measured before), is not counted as removed test.");
        }
    }

    private void findAddedTests(Map<TestMethodCall, Map<Type, Set<String>>> oldDepdendencies, TestExistenceChanges changes) {
        for (Map.Entry<TestMethodCall, CalledMethods> newDependency : this.dependencies.getDependencyMap().entrySet()) {
            TestMethodCall testcase = newDependency.getKey();
            if (oldDepdendencies.containsKey(testcase)) continue;
            changes.addAddedTest(testcase.onlyClazzEntity(), testcase);
            for (Map.Entry<Type, Set<String>> newCallees : newDependency.getValue().getCalledMethods().entrySet()) {
                Type changedclass = newCallees.getKey();
                for (String changedMethod : newCallees.getValue()) {
                    MethodCall methodEntity = new MethodCall(changedclass.getClazz(), changedclass.getModule(), changedMethod);
                    changes.addAddedTest((Type)methodEntity, testcase);
                }
            }
        }
    }

    public void addDependencies(TestMethodCall test, Map<Type, Set<String>> calledClasses) {
        this.dependencies.addDependencies(test, calledClasses);
    }
}

