/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.ConstructorFinder;
import de.dagere.peass.execution.gradle.GradleTestExecutor;
import de.dagere.peass.execution.maven.pom.MavenTestExecutor;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutorCreator {
    private static final Logger LOG = LogManager.getLogger(ExecutorCreator.class);

    public static boolean hasBuildfile(PeassFolders folders, TestTransformer testTransformer) {
        try {
            TestExecutor dummyExecutor = ExecutorCreator.createExecutor(folders, testTransformer, new EnvironmentVariables());
            return dummyExecutor.doesBuildfileExist();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static TestExecutor createExecutor(PeassFolders folders, TestTransformer testTransformer, EnvironmentVariables env) {
        String executorName = testTransformer.getConfig().getExecutionConfig().getTestExecutor();
        LOG.info(executorName);
        if (testTransformer != null && !executorName.equals("default")) {
            return ExecutorCreator.createDefinedExecutor(folders, testTransformer, env, executorName);
        }
        if (executorName.equals("default")) {
            return ExecutorCreator.createDefaultExecutor(folders, testTransformer, env);
        }
        throw new RuntimeException("Executor creation did not work, executor name: " + executorName);
    }

    private static TestExecutor createDefinedExecutor(PeassFolders folders, TestTransformer testTransformer, EnvironmentVariables env, String executorName) {
        try {
            Class<?> executorClazz = Class.forName(executorName);
            if (!ConstructorFinder.isSubclass(executorClazz, TestExecutor.class)) {
                throw new RuntimeException("Clazz " + executorName + " was given as executor, but no (direct) subclass of TestExecutor!");
            }
            Constructor<?> constructor = ConstructorFinder.findConstructor(executorClazz);
            TestExecutor transformer = (TestExecutor)constructor.newInstance(folders, testTransformer, env);
            return transformer;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Executor creation did not work, executor name: " + executorName, e);
        }
    }

    private static TestExecutor createDefaultExecutor(PeassFolders folders, TestTransformer testTransformer, EnvironmentVariables env) {
        File pom = new File(folders.getProjectFolder(), "pom.xml");
        File buildGradle = new File(folders.getProjectFolder(), "build.gradle");
        if (buildGradle.exists()) {
            return new GradleTestExecutor(folders, (JUnitTestTransformer)testTransformer, env);
        }
        if (pom.exists()) {
            return new MavenTestExecutor(folders, (JUnitTestTransformer)testTransformer, env);
        }
        throw new RuntimeException("No known buildfile (pom.xml  or build.gradle) in " + folders.getProjectFolder().getAbsolutePath() + " found; can not create test executor.");
    }

    public static TestTransformer createTestTransformer(PeassFolders folders, ExecutionConfig executionConfig, MeasurementConfig measurementConfig) {
        try {
            Class<?> testTransformerClass = Class.forName(executionConfig.getTestTransformer());
            if (!Arrays.asList(testTransformerClass.getInterfaces()).contains(TestTransformer.class)) {
                throw new RuntimeException("TestTransformer needs to be implemented by " + executionConfig.getTestTransformer());
            }
            Constructor<?> constructor = testTransformerClass.getConstructor(File.class, MeasurementConfig.class);
            TestTransformer transformer = (TestTransformer)constructor.newInstance(folders.getProjectFolder(), measurementConfig);
            return transformer;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.debug("Initialization was not possible; this should be thrown uncatched");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

