/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency;

import de.dagere.kopeme.parsing.BuildtoolProjectNameReader;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.dependency.ExecutorCreator;
import de.dagere.peass.dependency.RTSTestTransformerBuilder;
import de.dagere.peass.dependency.RunnableTestInformation;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KiekerResultManager {
    private static final Logger LOG = LogManager.getLogger(KiekerResultManager.class);
    protected final TestExecutor executor;
    protected final PeassFolders folders;
    protected final TestTransformer testTransformer;
    private RunnableTestInformation runnableTestsInformation;

    public KiekerResultManager(PeassFolders folders, ExecutionConfig executionConfig, KiekerConfig kiekerConfig, EnvironmentVariables env) {
        this.folders = folders;
        this.testTransformer = RTSTestTransformerBuilder.createTestTransformer(folders, executionConfig, kiekerConfig);
        this.executor = ExecutorCreator.createExecutor(folders, this.testTransformer, env);
    }

    public KiekerResultManager(TestExecutor executor, PeassFolders folders) {
        this.executor = executor;
        this.folders = folders;
        this.testTransformer = executor.getTestTransformer();
    }

    public TestTransformer getTestTransformer() {
        return this.testTransformer;
    }

    public ModuleClassMapping getModuleClassMapping() {
        return new ModuleClassMapping(this.executor);
    }

    public RunnableTestInformation getRunnableTestsInformation() {
        return this.runnableTestsInformation;
    }

    public void runTraceTests(TestSet testsToUpdate, String commit) {
        this.truncateKiekerResults();
        LOG.debug("Executing dependency update test, results folder: {}", (Object)this.folders.getTempMeasurementFolder());
        ModuleClassMapping mapping = new ModuleClassMapping(this.executor);
        this.runnableTestsInformation = this.testTransformer.buildTestMethodSet(testsToUpdate, mapping);
        this.executeKoPeMeKiekerRun(this.runnableTestsInformation.getTestsToUpdate(), commit, this.folders.getDependencyLogFolder());
    }

    private void truncateKiekerResults() {
        block5: {
            LOG.debug("Truncating: {}", (Object)this.folders.getTempMeasurementFolder().getAbsolutePath());
            try {
                FileUtils.deleteDirectory((File)this.folders.getTempMeasurementFolder());
                File outputFolder = new File(this.folders.getProjectFolder(), "output");
                if (this.folders.getProjectName().equals("tomcat") && outputFolder.exists()) {
                    FileUtils.deleteDirectory((File)outputFolder);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!this.folders.getTempMeasurementFolder().exists()) break block5;
                try {
                    FileUtils.deleteDirectory((File)this.folders.getTempMeasurementFolder());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void executeKoPeMeKiekerRun(TestSet testsToUpdate, String commit, File logFolder) {
        File commitLogFolder = new File(logFolder, commit);
        if (!commitLogFolder.exists()) {
            commitLogFolder.mkdir();
        }
        this.executor.prepareKoPeMeExecution(new File(commitLogFolder, "clean.txt"));
        for (TestMethodCall testcase : testsToUpdate.getTestMethods()) {
            this.executor.executeTest(testcase, commitLogFolder, this.testTransformer.getConfig().getTimeoutInSeconds());
        }
        LOG.debug("KoPeMe-Kieker-Run finished");
    }

    protected void cleanFolderAboveSize(File folderToClean, long sizeInMb) {
        for (File file : folderToClean.listFiles()) {
            if (!file.isDirectory()) continue;
            long size = FileUtils.sizeOfDirectory((File)file) / 0x100000L;
            LOG.debug("File: {} Size: {}", (Object)file, (Object)size);
            if (size <= sizeInMb) continue;
            LOG.debug("Deleting file.");
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public File getJSONFileFolder(File moduleFolder) {
        return KiekerResultManager.getJSONFileFolder(this.folders, moduleFolder);
    }

    public static File getJSONFileFolder(PeassFolders folders, File moduleFolder) {
        File jsonFileFolder = null;
        BuildtoolProjectNameReader buildtoolProjectNameReader = new BuildtoolProjectNameReader();
        if (buildtoolProjectNameReader.searchBuildfile(moduleFolder, 1)) {
            String name = buildtoolProjectNameReader.getProjectName();
            jsonFileFolder = new File(folders.getTempMeasurementFolder(), name);
        } else {
            LOG.error("No buildfile found in {}", (Object)moduleFolder);
        }
        return jsonFileFolder;
    }

    public void deleteTempFiles() {
        this.executor.deleteTemporaryFiles();
    }

    public TestExecutor getExecutor() {
        return this.executor;
    }
}

