/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency;

import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.execution.maven.pom.MavenPomUtil;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestFinder {
    private static final Logger LOG = LogManager.getLogger(TestFinder.class);
    protected final TestExecutor executor;

    public TestFinder(TestExecutor executor) {
        this.executor = executor;
    }

    public TestSet findIncludedTests(ModuleClassMapping mapping) throws IOException {
        List<String> includedModules = this.getIncludedModules();
        TestTransformer testTransformer = this.executor.getTestTransformer();
        return testTransformer.findModuleTests(mapping, includedModules, this.executor.getModules());
    }

    private List<String> getIncludedModules() throws IOException {
        List<String> includedModules;
        if (this.executor.getTestTransformer().getConfig().getExecutionConfig().getPl() != null) {
            String pl = this.executor.getTestTransformer().getConfig().getExecutionConfig().getPl();
            includedModules = MavenPomUtil.getDependentModules(this.executor.getFolders().getProjectFolder(), pl, this.executor.getEnv());
            LOG.debug("Included modules: {}", includedModules);
        } else {
            includedModules = null;
        }
        return includedModules;
    }
}

