/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.analysis;

import de.dagere.kopeme.kieker.writer.onecall.OneCallReader;
import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.dependency.analysis.CalledMethodStage;
import de.dagere.peass.dependency.analysis.KiekerReader;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.EntityUtil;
import de.dagere.peass.dependency.analysis.data.TraceElement;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kieker.analysis.exception.AnalysisConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CalledMethodLoader {
    private static final Logger LOG = LogManager.getLogger(CalledMethodLoader.class);
    private final File kiekerTraceFolder;
    private final ModuleClassMapping mapping;
    private final KiekerConfig kiekerConfig;

    public CalledMethodLoader(File kiekerTraceFolder, ModuleClassMapping mapping, KiekerConfig kiekerConfig) {
        this.kiekerTraceFolder = kiekerTraceFolder;
        this.mapping = mapping;
        this.kiekerConfig = kiekerConfig;
    }

    public Map<Type, Set<String>> getCalledMethods() {
        try {
            if (this.kiekerConfig.isOnlyOneCallRecording()) {
                Map<Type, Set<String>> calledMethodResult = this.loadMethods();
                return calledMethodResult;
            }
            CalledMethodStage peassFilter = this.executePeassFilter(null);
            return peassFilter.getCalledMethods();
        }
        catch (IllegalStateException | AnalysisConfigurationException e) {
            LOG.debug("Failed to load methods", e);
            e.printStackTrace();
            return null;
        }
    }

    private Map<Type, Set<String>> loadMethods() {
        Set calledMethods = OneCallReader.getCalledMethods((File)this.kiekerTraceFolder);
        HashMap<Type, Set<String>> calledMethodResult = new HashMap<Type, Set<String>>();
        for (String calledMethod : calledMethods) {
            LOG.debug("Adding called method: {}", (Object)calledMethod);
            MethodCall entity = EntityUtil.determineEntityWithDotSeparator(calledMethod);
            String outerClazzName = TypeFileFinder.getOuterClass((String)entity.getClazz());
            String moduleOfClass = this.mapping.getModuleOfClass(outerClazzName);
            Type fullClassEntity = new Type(entity.getClazz(), moduleOfClass);
            HashSet<CallSite> currentMethodSet = (HashSet<CallSite>)calledMethodResult.get(fullClassEntity);
            if (currentMethodSet == null) {
                currentMethodSet = new HashSet<CallSite>();
                calledMethodResult.put(fullClassEntity, currentMethodSet);
            }
            currentMethodSet.add((CallSite)((Object)(entity.getMethod() + entity.getParameterString())));
        }
        return calledMethodResult;
    }

    public ArrayList<TraceElement> getShortTrace(String prefix) {
        try {
            long size = FileUtils.sizeOfDirectory((File)this.kiekerTraceFolder);
            long sizeInMB = size / 0x100000L;
            LOG.debug("Size: {} ({}) Folder: {}", (Object)sizeInMB, (Object)size, (Object)this.kiekerTraceFolder);
            if (sizeInMB < this.kiekerConfig.getTraceSizeInMb()) {
                if (this.kiekerConfig.isOnlyOneCallRecording()) {
                    ArrayList<TraceElement> result = this.readOneCallTrace();
                    return result;
                }
                CalledMethodStage peassFilter = this.executePeassFilter(prefix);
                return peassFilter.getCalls();
            }
            LOG.error("Trace size: {} MB - skipping", (Object)sizeInMB);
            return null;
        }
        catch (IllegalStateException | AnalysisConfigurationException e) {
            LOG.debug("Failed to load trace", e);
            e.printStackTrace();
            return null;
        }
    }

    private ArrayList<TraceElement> readOneCallTrace() {
        ArrayList<TraceElement> result = new ArrayList<TraceElement>();
        Set calledMethods = OneCallReader.getCalledMethods((File)this.kiekerTraceFolder);
        for (String calledMethod : calledMethods) {
            MethodCall entity = EntityUtil.determineEntityWithDotSeparator(calledMethod);
            String outerClazzName = TypeFileFinder.getOuterClass((String)entity.getClazz());
            String moduleOfClass = this.mapping.getModuleOfClass(outerClazzName);
            TraceElement traceelement = new TraceElement(entity.getClazz(), entity.getMethod(), 0, moduleOfClass);
            if (calledMethod.contains(" static ")) {
                traceelement.setStatic(true);
            }
            traceelement.setParameterTypes(entity.getParameterTypes());
            result.add(traceelement);
        }
        return result;
    }

    private CalledMethodStage executePeassFilter(String prefix) throws AnalysisConfigurationException {
        CalledMethodStage peassStage = KiekerReader.getCalledMethodStage(this.kiekerTraceFolder, prefix, this.mapping);
        return peassStage;
    }

    public static void main(String[] args) {
        File kiekerTraceFile = new File(args[0]);
        KiekerConfig kiekerConfig = new KiekerConfig();
        kiekerConfig.setTraceSizeInMb(10000L);
        ArrayList<TraceElement> trace = new CalledMethodLoader(kiekerTraceFile, null, kiekerConfig).getShortTrace("");
        System.out.println("Trace-Size: " + trace.size());
    }
}

