/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.analysis;

import de.dagere.nodeDiffDetector.data.MethodCallHelper;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TraceElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kieker.analysis.architecture.trace.AbstractTraceProcessingStage;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.Execution;
import kieker.model.system.model.ExecutionTrace;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CalledMethodStage
extends AbstractTraceProcessingStage<ExecutionTrace> {
    private static final Logger LOG = LogManager.getLogger(CalledMethodStage.class);
    private final Map<Type, Set<String>> calledMethods = new HashMap<Type, Set<String>>();
    private final ArrayList<TraceElement> calls = new ArrayList();
    private final String prefix;
    private final ModuleClassMapping mapping;
    private static final int CALLCOUNT = 10000000;

    public CalledMethodStage(SystemModelRepository systemModelRepository, String prefix, ModuleClassMapping mapping) {
        super(systemModelRepository);
        this.prefix = prefix;
        this.mapping = mapping;
    }

    protected void execute(ExecutionTrace trace) throws Exception {
        LOG.trace("Trace: {}", (Object)trace.getTraceId());
        for (Execution execution : trace.getTraceAsSortedExecutionSet()) {
            String methodname;
            if (this.calls.size() > 10000000) {
                this.calls.add(new TraceElement("ATTENTION", "TO MUCH CALLS", 0));
                LOG.info("Trace Reading Aborted, Cause More Than 10000000 Appeared");
                break;
            }
            String fullClassname = execution.getOperation().getComponentType().getFullQualifiedName().intern();
            if (this.prefix != null && (this.prefix == null || !fullClassname.startsWith(this.prefix)) || fullClassname.contains("junit") || fullClassname.contains("log4j") || fullClassname.equals("de.peass.generated.GeneratedTest") || (methodname = execution.getOperation().getSignature().getName().intern()).equals("logFullData") || methodname.equals("useKieker") || methodname.equals("getWarmupExecutions") || methodname.equals("getExecutionTimes") || methodname.equals("getMaximalTime") || methodname.equals("getRepetitions") || methodname.equals("getDataCollectors")) continue;
            TraceElement traceelement = this.buildTraceElement(execution, fullClassname, methodname);
            this.calls.add(traceelement);
            String methodWithParameters = methodname + MethodCallHelper.getParameterString((String[])execution.getOperation().getSignature().getParamTypeList());
            this.addCalledMethod(fullClassname, methodWithParameters, traceelement);
        }
        LOG.trace("Finished");
    }

    private void addCalledMethod(String fullClassname, String methodname, TraceElement traceelement) {
        String outerClazzName = TypeFileFinder.getOuterClass((String)fullClassname);
        String moduleOfClass = this.mapping.getModuleOfClass(outerClazzName);
        Type fullClassEntity = new Type(fullClassname, moduleOfClass);
        traceelement.setModule(moduleOfClass);
        Set<String> currentMethodSet = this.calledMethods.get(fullClassEntity);
        if (currentMethodSet == null) {
            currentMethodSet = new HashSet<String>();
            this.calledMethods.put(fullClassEntity, currentMethodSet);
        }
        currentMethodSet.add(methodname);
    }

    private TraceElement buildTraceElement(Execution execution, String fullClassname, String methodname) {
        TraceElement traceelement = new TraceElement(fullClassname, methodname, execution.getEss());
        if (Arrays.asList(execution.getOperation().getSignature().getModifier()).contains("static")) {
            traceelement.setStatic(true);
        }
        Object[] paramTypeList = execution.getOperation().getSignature().getParamTypeList();
        LOG.trace("Parameters " + fullClassname + " " + methodname + " " + Arrays.toString(paramTypeList));
        LOG.trace((Object)paramTypeList.length);
        String[] internParamTypeList = CalledMethodStage.getInternTypeList((String[])paramTypeList);
        traceelement.setParameterTypes(internParamTypeList);
        return traceelement;
    }

    public static String[] getInternTypeList(String[] paramTypeList) {
        LinkedList<Object> parameters = new LinkedList<Object>();
        int remainingOpen = 0;
        for (int i = 0; i < paramTypeList.length; ++i) {
            int closeCount;
            int openCount;
            if (remainingOpen > 0) {
                openCount = StringUtils.countMatches((CharSequence)paramTypeList[i], (char)'<');
                closeCount = StringUtils.countMatches((CharSequence)paramTypeList[i], (char)'>');
                remainingOpen += openCount - closeCount;
                String appendedParameter = (String)parameters.get(parameters.size() - 1) + paramTypeList[i];
                parameters.set(parameters.size() - 1, appendedParameter);
                continue;
            }
            if (paramTypeList[i].contains("<")) {
                openCount = StringUtils.countMatches((CharSequence)paramTypeList[i], (char)'<');
                closeCount = StringUtils.countMatches((CharSequence)paramTypeList[i], (char)'>');
                remainingOpen = openCount - closeCount;
                parameters.add(paramTypeList[i]);
                continue;
            }
            parameters.add(paramTypeList[i].intern());
        }
        String[] internParamTypeList = parameters.toArray(new String[0]);
        return internParamTypeList;
    }

    public ArrayList<TraceElement> getCalls() {
        return this.calls;
    }

    public Map<Type, Set<String>> getCalledMethods() {
        return this.calledMethods;
    }
}

