/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.analysis;

import de.dagere.peass.dependency.analysis.CalledMethodStage;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import kieker.analysis.architecture.trace.execution.ExecutionRecordTransformationStage;
import kieker.analysis.architecture.trace.reconstruction.TraceReconstructionStage;
import kieker.analysis.generic.DynamicEventDispatcher;
import kieker.analysis.generic.IEventMatcher;
import kieker.analysis.generic.ImplementsEventMatcher;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.model.repository.SystemModelRepository;
import kieker.tools.source.LogsReaderCompositeStage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import teetime.framework.Configuration;

public class KiekerReaderConfiguration
extends Configuration {
    private static final Logger LOG = LogManager.getLogger(KiekerReaderConfiguration.class);
    protected SystemModelRepository systemModelRepositoryNew = new SystemModelRepository();

    public CalledMethodStage exampleReader(File kiekerTraceFolder, String prefix, ModuleClassMapping mapping) {
        TraceReconstructionStage traceReconstructionStage = this.prepareTillExecutionTrace(kiekerTraceFolder);
        CalledMethodStage myStage = new CalledMethodStage(this.systemModelRepositoryNew, prefix, mapping);
        this.connectPorts(traceReconstructionStage.getExecutionTraceOutputPort(), myStage.getInputPort());
        LOG.debug("Reading from {}", (Object)kiekerTraceFolder);
        return myStage;
    }

    protected TraceReconstructionStage prepareTillExecutionTrace(File kiekerTraceFolder) {
        ExecutionRecordTransformationStage executionRecordTransformationStage = this.prepareTillExecutions(kiekerTraceFolder);
        TraceReconstructionStage traceReconstructionStage = new TraceReconstructionStage(this.systemModelRepositoryNew, TimeUnit.MILLISECONDS, false, Long.valueOf(Long.MAX_VALUE));
        this.connectPorts(executionRecordTransformationStage.getOutputPort(), traceReconstructionStage.getInputPort());
        return traceReconstructionStage;
    }

    protected ExecutionRecordTransformationStage prepareTillExecutions(File kiekerTraceFolder) {
        LinkedList<File> inputDirs = new LinkedList<File>();
        inputDirs.add(kiekerTraceFolder);
        LogsReaderCompositeStage logReaderStage = new LogsReaderCompositeStage(inputDirs, true, Integer.valueOf(4096));
        ExecutionRecordTransformationStage executionRecordTransformationStage = new ExecutionRecordTransformationStage(this.systemModelRepositoryNew);
        DynamicEventDispatcher dispatcher = new DynamicEventDispatcher(null, false, true, false);
        ImplementsEventMatcher operationExecutionRecordMatcher = new ImplementsEventMatcher(OperationExecutionRecord.class, null);
        dispatcher.registerOutput((IEventMatcher)operationExecutionRecordMatcher);
        this.connectPorts(logReaderStage.getOutputPort(), dispatcher.getInputPort());
        this.connectPorts(operationExecutionRecordMatcher.getOutputPort(), executionRecordTransformationStage.getInputPort());
        return executionRecordTransformationStage;
    }
}

