/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.analysis;

import de.dagere.nodeDiffDetector.config.FolderConfig;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.execution.utils.TestExecutor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleClassMapping {
    public static final ModuleClassMapping SINGLE_MODULE_MAPPING = new ModuleClassMapping();
    private static final Logger LOG = LogManager.getLogger(ModuleClassMapping.class);
    private final Map<String, String> mapping = new HashMap<String, String>();
    private final List<File> modules;

    private ModuleClassMapping() {
        this.modules = null;
    }

    public ModuleClassMapping(File baseFolder, ProjectModules modules, ExecutionConfig config) {
        for (File module : modules.getModules()) {
            TypeFileFinder finder = new TypeFileFinder((FolderConfig)config);
            this.populateModule(baseFolder, module, finder);
        }
        this.modules = modules.getModules();
    }

    private void populateModule(File baseFolder, File module, TypeFileFinder finder) {
        List classes = finder.getTypes(module);
        String moduleName = module.equals(baseFolder) ? "" : ModuleClassMapping.getModuleName(baseFolder, module);
        LOG.debug("Module: {} Name: {}", (Object)module.getAbsolutePath(), (Object)moduleName);
        for (String clazz : classes) {
            this.mapping.put(clazz, moduleName);
        }
    }

    public ModuleClassMapping(TestExecutor executor) {
        this(executor.getProjectFolder(), executor.getModules(), executor.getTestTransformer().getConfig().getExecutionConfig());
    }

    public String getModuleOfClass(String clazz) {
        if (this == SINGLE_MODULE_MAPPING) {
            return "";
        }
        return this.mapping.get(clazz);
    }

    public static String getModuleName(File baseFolder, File module) {
        try {
            int pathIndex = baseFolder.getCanonicalPath().length() + 1;
            String modulePath = module.getCanonicalPath();
            String moduleName = modulePath.length() > pathIndex ? modulePath.substring(pathIndex) : "";
            return moduleName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getAllClasses() {
        LinkedList<String> clazzes = new LinkedList<String>();
        for (String clazz : this.mapping.values()) {
            clazzes.add(clazz);
        }
        return clazzes;
    }

    public List<File> getModules() {
        return this.modules;
    }
}

