/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.analysis.data;

import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.config.ExecutionConfig;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommitDiff {
    private static final Logger LOG = LogManager.getLogger(CommitDiff.class);
    private boolean pomChanged = false;
    private final List<Type> changedClasses = new LinkedList<Type>();
    private final List<File> modules;
    private final File projectFolder;

    public CommitDiff(List<File> modules, File projectFolder) {
        this.modules = modules;
        this.projectFolder = projectFolder;
    }

    public boolean isPomChanged() {
        return this.pomChanged;
    }

    public void setPomChanged(boolean pomChanged) {
        this.pomChanged = pomChanged;
    }

    public List<Type> getChangedClasses() {
        return this.changedClasses;
    }

    public void addChange(String currentFileName, ExecutionConfig config) {
        if (currentFileName.endsWith("pom.xml")) {
            this.setPomChanged(true);
        } else if (currentFileName.endsWith(".java")) {
            String fileNameWithoutExtension = currentFileName.substring(0, currentFileName.length() - ".java".length());
            String containedPath = this.checkContainedPath(fileNameWithoutExtension, config);
            this.addContainedPathFile(currentFileName, config, containedPath);
        } else if (currentFileName.endsWith(".scala")) {
            String fileNameWithoutExtension = currentFileName.substring(0, currentFileName.length() - ".scala".length());
            String containedPath = this.checkContainedPath(fileNameWithoutExtension, config);
            this.addContainedPathFile(currentFileName, config, containedPath);
        }
    }

    private void addContainedPathFile(String currentFileName, ExecutionConfig config, String containedPath) {
        if (containedPath != null) {
            int indexOf = currentFileName.indexOf(containedPath);
            if (indexOf == -1) {
                LOG.error("Did not find any of the class pathes in the changed filename: {} classpathes: {} ", (Object)currentFileName, config.getAllClazzFolders());
            } else {
                this.addChange(currentFileName, containedPath, indexOf);
            }
        } else {
            LOG.info("Did not find matching class folder for file {}", (Object)currentFileName);
        }
    }

    private String checkContainedPath(String fileNameWithoutExtension, ExecutionConfig config) {
        String containedPath = null;
        for (String path : config.getAllClazzFolders()) {
            if (!fileNameWithoutExtension.contains(path)) continue;
            containedPath = path;
            break;
        }
        return containedPath;
    }

    private void addChange(String currentFileName, String containedPath, int indexOf) {
        if (indexOf != 0) {
            String pathWithFolder = currentFileName.substring(indexOf);
            String classPath = CommitDiff.replaceClazzFolderFromName(pathWithFolder, containedPath);
            String modulePath = currentFileName.substring(0, indexOf - 1);
            File moduleFile = new File(this.projectFolder, modulePath);
            if (this.modules.contains(moduleFile)) {
                LOG.trace("Create new changedentitty: {} {}", (Object)classPath, (Object)modulePath);
                Type changedEntity = new Type(classPath, modulePath);
                if (!changedEntity.getJavaClazzName().contains(File.separator)) {
                    this.changedClasses.add(changedEntity);
                } else {
                    LOG.error("Sourcefoldernot found: {} Ignoring {}", (Object)modulePath, (Object)currentFileName);
                }
            } else {
                LOG.error("Unexpected Module: {} Ignoring {}", (Object)modulePath, (Object)currentFileName);
                LOG.info("Modules: {}", this.modules);
            }
        } else {
            String classPath = CommitDiff.replaceClazzFolderFromName(currentFileName, containedPath);
            Type changedEntity = new Type(classPath, "");
            if (!changedEntity.getJavaClazzName().contains(File.separator)) {
                this.changedClasses.add(changedEntity);
            } else {
                LOG.error("Sourcefoldernot found: {}", (Object)currentFileName);
            }
        }
    }

    public static String replaceClazzFolderFromName(String fileName, String classFolderName) {
        String replaced;
        String tempClazzName = fileName.replace(".java", "").replace(".scala", "");
        if ((tempClazzName = tempClazzName.replaceAll(classFolderName, "")).startsWith(File.separator) || tempClazzName.startsWith("/")) {
            tempClazzName = tempClazzName.substring(1);
        }
        if ((replaced = tempClazzName.replace(File.separatorChar, '.')).contains("/")) {
            replaced = replaced.replace('/', '.');
        }
        return replaced;
    }

    public String toString() {
        String ret = "Pom: " + this.pomChanged + " Classes: ";
        for (Type cl : this.changedClasses) {
            if (cl.getModule().length() > 0) {
                ret = ret + cl.getClazz() + "\n";
                continue;
            }
            ret = ret + cl.getModule() + "-" + cl.getClazz() + "\n";
        }
        return ret;
    }
}

