/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.analysis.data;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.diffDetection.ClazzChangeData;
import de.dagere.peass.dependency.analysis.data.CalledMethods;
import de.dagere.peass.dependency.analysis.data.ChangeTestMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestDependencies {
    private static final Logger LOG = LogManager.getLogger(TestDependencies.class);
    private final Map<TestMethodCall, CalledMethods> dependencyMap = new HashMap<TestMethodCall, CalledMethods>();

    public Map<TestMethodCall, CalledMethods> getDependencyMap() {
        return this.dependencyMap;
    }

    public Map<Type, Set<String>> getOrAddDependenciesForTest(TestMethodCall test) {
        CalledMethods tests = this.dependencyMap.get(test);
        if (tests == null) {
            tests = new CalledMethods();
            this.dependencyMap.put(test, tests);
            Type onlyClass = new Type(test.getClazz(), test.getModule());
            HashSet<String> calledMethods = new HashSet<String>();
            tests.getCalledMethods().put(onlyClass, calledMethods);
            Object method = test.getMethod();
            if (test.getParams() != null) {
                method = (String)method + "(" + test.getParams() + ")";
            }
            calledMethods.add((String)method);
        }
        return tests.getCalledMethods();
    }

    public void setDependencies(TestMethodCall testClassName, Map<Type, Set<String>> allCalledClasses) {
        Map<Type, Set<String>> testDependencies = this.getOrAddDependenciesForTest(testClassName);
        testDependencies.putAll(allCalledClasses);
    }

    public void addDependencies(TestMethodCall testMethod, Map<Type, Set<String>> calledClasses) {
        Map<Type, Set<String>> testDependencies = this.getOrAddDependenciesForTest(testMethod);
        for (Map.Entry<Type, Set<String>> calledEntity : calledClasses.entrySet()) {
            LOG.debug("Adding call: " + String.valueOf(calledEntity.getKey()));
            LOG.debug(testDependencies.keySet());
            Set<String> oldSet = testDependencies.get(calledEntity.getKey());
            if (oldSet != null) {
                oldSet.addAll((Collection<String>)calledEntity.getValue());
                continue;
            }
            testDependencies.put(calledEntity.getKey(), calledEntity.getValue());
        }
    }

    public void removeTest(TestCase entity) {
        this.dependencyMap.remove(entity);
    }

    public int size() {
        return this.dependencyMap.size();
    }

    public Map<TestMethodCall, Map<Type, Set<String>>> getCopiedDependencies() {
        HashMap<TestMethodCall, Map<Type, Set<String>>> copy = new HashMap<TestMethodCall, Map<Type, Set<String>>>();
        for (Map.Entry<TestMethodCall, CalledMethods> entry : this.dependencyMap.entrySet()) {
            HashMap dependencies = new HashMap();
            for (Map.Entry<Type, Set<String>> testcase : entry.getValue().getCalledMethods().entrySet()) {
                HashSet copiedMethods = new HashSet();
                copiedMethods.addAll(testcase.getValue());
                dependencies.put(testcase.getKey(), copiedMethods);
            }
            copy.put(entry.getKey(), dependencies);
        }
        return copy;
    }

    public String toString() {
        return this.dependencyMap.toString();
    }

    public ChangeTestMapping getChangeTestMap(Map<Type, ClazzChangeData> changes) {
        ChangeTestMapping changeTestMap = new ChangeTestMapping();
        for (Map.Entry<TestMethodCall, CalledMethods> entry : this.dependencyMap.entrySet()) {
            TestMethodCall currentTestcase = entry.getKey();
            CalledMethods currentTestDependencies = entry.getValue();
            for (ClazzChangeData changedEntry : changes.values()) {
                for (Type change : changedEntry.getChanges()) {
                    Type changedClass = change.onlyClazz();
                    Set<Type> calledClasses = currentTestDependencies.getCalledClasses();
                    if (!calledClasses.contains(changedClass)) continue;
                    this.addCall(changeTestMap, currentTestcase, currentTestDependencies, changedEntry, change, changedClass);
                }
            }
        }
        for (Map.Entry<Object, Object> entry : changeTestMap.getChanges().entrySet()) {
            LOG.debug("Change: {} Calling: {} {}", entry.getKey(), (Object)((Set)entry.getValue()).size(), entry.getValue());
        }
        return changeTestMap;
    }

    private void addCall(ChangeTestMapping changeTestMap, TestMethodCall currentTestcase, CalledMethods currentTestDependencies, ClazzChangeData changedEntry, Type change, Type changedClass) {
        boolean clazzLevelChange;
        boolean bl = clazzLevelChange = !changedEntry.isOnlyMethodChange();
        if (clazzLevelChange) {
            changeTestMap.addChangeEntry(change, currentTestcase);
            changeTestMap.addChangeEntry(change.onlyClazz(), currentTestcase);
        } else {
            MethodCall changeCall = (MethodCall)change;
            String method = changeCall.getMethod() + changeCall.getParameterString();
            Map<Type, Set<String>> calledMethods = currentTestDependencies.getCalledMethods();
            Set<String> calledMethodsInChangeClass = calledMethods.get(changedClass);
            if (calledMethodsInChangeClass.contains(method)) {
                MethodCall classWithMethod = new MethodCall(changedClass.getClazz(), changedClass.getModule(), method);
                changeTestMap.addChangeEntry((Type)classWithMethod, currentTestcase);
            }
        }
    }
}

