/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.analysis.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.serialization.TestClazzCallKeyDeserializer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestSet {
    private static final Logger LOG = LogManager.getLogger(TestSet.class);
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(keyUsing=TestClazzCallKeyDeserializer.class, contentAs=TreeSet.class, as=TreeMap.class)
    private final Map<TestClazzCall, Set<String>> testcases = new TreeMap<TestClazzCall, Set<String>>();
    private String predecessor;

    public TestSet() {
    }

    public TestSet(String testcase) {
        this.addTest(TestMethodCall.createFromString((String)testcase));
    }

    public TestSet(TestMethodCall testcase) {
        this.addTest(testcase);
    }

    public TestSet(List<String> testcases) {
        for (String testcase : testcases) {
            this.addTest(TestMethodCall.createFromString((String)testcase));
        }
    }

    @JsonIgnore
    public void addTest(TestMethodCall testcase) {
        TestClazzCall entity = new TestClazzCall(testcase.getClazz(), testcase.getModule());
        this.addTest(entity, testcase.getMethodWithParams());
    }

    public void addTest(TestClazzCall classname, String methodname) {
        String internalizedMethodName;
        Set<String> methods = this.testcases.get(classname);
        if (methods == null) {
            methods = new TreeSet<String>();
            this.testcases.put(classname.copy(), methods);
        }
        if (methodname != null && !methods.contains(internalizedMethodName = methodname.intern())) {
            methods.add(internalizedMethodName);
        }
    }

    @JsonIgnore
    public void addTestSet(TestSet testSet) {
        for (Map.Entry<TestClazzCall, Set<String>> newTestEntry : testSet.entrySet()) {
            Set<String> methods = this.testcases.get(newTestEntry.getKey());
            if (methods == null) {
                methods = new TreeSet<String>();
                methods.addAll((Collection<String>)newTestEntry.getValue());
                this.testcases.put(newTestEntry.getKey().copy(), methods);
                continue;
            }
            if (newTestEntry.getValue().size() != 0 && methods.size() != 0) {
                methods.addAll((Collection<String>)newTestEntry.getValue());
                continue;
            }
            methods.clear();
        }
    }

    @JsonIgnore
    public Set<Map.Entry<TestClazzCall, Set<String>>> entrySet() {
        return this.testcases.entrySet();
    }

    @JsonIgnore
    public int classCount() {
        return this.testcases.size();
    }

    @JsonIgnore
    public Set<TestClazzCall> getClasses() {
        return this.testcases.keySet();
    }

    @JsonIgnore
    public Set<TestCase> getTests() {
        LinkedHashSet<TestCase> testcases = new LinkedHashSet<TestCase>();
        for (Map.Entry<TestClazzCall, Set<String>> classTests : this.getTestcases().entrySet()) {
            String clazz = classTests.getKey().getClazz();
            String module = classTests.getKey().getModule();
            if (classTests.getValue().size() > 0) {
                for (String method : classTests.getValue()) {
                    TestMethodCall testcase = new TestMethodCall(clazz, method, module);
                    testcases.add((TestCase)testcase);
                }
                continue;
            }
            TestClazzCall testClazzCall = new TestClazzCall(clazz, module);
            testcases.add((TestCase)testClazzCall);
        }
        return testcases;
    }

    @JsonIgnore
    public Set<TestClazzCall> getTestClazzes() {
        LinkedHashSet<TestClazzCall> testcases = new LinkedHashSet<TestClazzCall>();
        for (Map.Entry<TestClazzCall, Set<String>> classTests : this.getTestcases().entrySet()) {
            String clazz = classTests.getKey().getClazz();
            String module = classTests.getKey().getModule();
            if (classTests.getValue().size() != 0) continue;
            TestClazzCall testClazzCall = new TestClazzCall(clazz, module);
            testcases.add(testClazzCall);
        }
        return testcases;
    }

    @JsonIgnore
    public Set<TestMethodCall> getTestMethods() {
        LinkedHashSet<TestMethodCall> testcases = new LinkedHashSet<TestMethodCall>();
        for (Map.Entry<TestClazzCall, Set<String>> classTests : this.getTestcases().entrySet()) {
            String clazz = classTests.getKey().getClazz();
            String module = classTests.getKey().getModule();
            if (classTests.getValue().size() <= 0) continue;
            for (String method : classTests.getValue()) {
                TestMethodCall testcase = new TestMethodCall(clazz, method, module);
                testcases.add(testcase);
            }
        }
        return testcases;
    }

    public Map<TestClazzCall, Set<String>> getTestcases() {
        return this.testcases;
    }

    public void removeTest(TestClazzCall testClassName) {
        this.testcases.remove(testClassName);
    }

    @JsonIgnore
    public void removeTest(TestClazzCall testClassName, String testMethodName) {
        Set<String> testMethods = this.testcases.get(testClassName);
        if (testMethods != null) {
            this.removeMethod((TestCase)testClassName, testMethodName, testMethods);
        } else {
            TestCase other = null;
            for (TestCase testCase : this.testcases.keySet()) {
                if (!testCase.getClazz().equals(testClassName.getClazz())) continue;
                other = testCase;
            }
            if (other != null) {
                LOG.warn("{} not found - found {} instead. Modules should be saved in ChangedEntity-instances!", (Object)testClassName, other);
                this.removeMethod(other, testMethodName, this.testcases.get(other));
            } else {
                LOG.error("Testclass " + String.valueOf(testClassName) + " missing");
            }
        }
    }

    private void removeMethod(TestCase testClassName, String testMethodName, Set<String> testMethods) {
        LOG.trace("Removing: " + String.valueOf(testClassName) + "#" + testMethodName);
        if (!testMethods.remove(testMethodName)) {
            LOG.error("Problem: " + testMethodName + " can not be removed.");
        }
        if (testMethods.size() == 0) {
            this.testcases.remove(testClassName);
        }
    }

    public String toString() {
        return this.testcases.toString();
    }

    @JsonIgnore
    public Set<String> getMethods(TestClazzCall clazz) {
        return this.testcases.get(clazz);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getPredecessor() {
        return this.predecessor;
    }

    public void setPredecessor(String predecessor) {
        this.predecessor = predecessor;
    }

    public boolean containsTest(TestMethodCall test) {
        Set<String> methods = this.testcases.get(new TestClazzCall(test.getClazz(), test.getModule()));
        return methods != null && methods.contains(test.getMethod());
    }
}

