/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.parallel;

import com.github.javaparser.ParseException;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.reader.DependencyReader;
import de.dagere.peass.dependency.reader.RunningCommitFinder;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.vcs.CommitIterator;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class OneReader
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(OneReader.class);
    private final String minimumCommit;
    private final CommitIterator reserveIterator;
    final RunningCommitFinder firstRunningCommitFinder;
    private final DependencyReader reader;
    private final CommitComparatorInstance comparator;

    public OneReader(String minimumCommit, CommitIterator reserveIterator, DependencyReader reader, RunningCommitFinder firstRunningCommitFinder, CommitComparatorInstance comparator) {
        this.minimumCommit = minimumCommit;
        this.reserveIterator = reserveIterator;
        this.firstRunningCommitFinder = firstRunningCommitFinder;
        this.reader = reader;
        this.comparator = comparator;
    }

    @Override
    public void run() {
        try {
            boolean init = this.firstRunningCommitFinder.searchFirstRunningCommit();
            if (init) {
                LOG.debug("Reader initalized: " + String.valueOf(this.reader) + " This: " + String.valueOf(this));
                if (!this.reader.readInitialCommit()) {
                    LOG.error("Analyzing first commit was not possible");
                } else {
                    boolean readingSuccess = this.reader.readDependencies();
                    if (readingSuccess) {
                        this.readRemaining(this.reader);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void readRemaining(DependencyReader reader) throws FileNotFoundException, IOException, XmlPullParserException, InterruptedException, ParseException {
        String newest = reader.getDependencies().getNewestCommit();
        reader.setIterator(this.reserveIterator);
        while (this.reserveIterator.hasNextCommit() && this.comparator.isBefore(newest, this.minimumCommit)) {
            this.reserveIterator.goToNextCommit();
            LOG.debug("Remaining: {} This: {}", (Object)this.reserveIterator.getCommitName(), (Object)this);
            reader.readCommit();
            newest = reader.getDependencies().getNewestCommit();
        }
        this.serializeNotRunningCommits(reader);
    }

    private void serializeNotRunningCommits(DependencyReader reader) {
        reader.getDependencies().getCommits().entrySet().stream().filter(commit -> !((CommitStaticSelection)commit.getValue()).isRunning()).map(entry -> (String)entry.getKey()).forEach(commit -> this.firstRunningCommitFinder.getNonRunning().addCommit((String)commit, "Commit was not executable during analysis."));
    }
}

