/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.parallel;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependency.reader.DependencyParallelReader;
import de.dagere.peass.dependency.reader.DependencyReaderUtil;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartialSelectionResultsMerger {
    private static final Logger LOG = LogManager.getLogger(DependencyParallelReader.class);

    private PartialSelectionResultsMerger() {
    }

    public static ExecutionData mergePartialData(CommitComparatorInstance comparator, ResultsFolders[] outFiles, ResultsFolders mergedFolders) throws IOException, JsonGenerationException, JsonMappingException, JsonParseException {
        File out = mergedFolders.getStaticTestSelectionFile();
        PartialSelectionResultsMerger.mergeSelectionResults(out, outFiles, comparator);
        ExecutionData executionData = PartialSelectionResultsMerger.mergeExecutions(mergedFolders, outFiles, comparator);
        PartialSelectionResultsMerger.mergeViews(outFiles, mergedFolders);
        return executionData;
    }

    private static void mergeViews(ResultsFolders[] outFiles, ResultsFolders mergedFolders) throws IOException {
        for (ResultsFolders resultsFolders : outFiles) {
            for (File viewFolder : resultsFolders.getViewFolder().listFiles()) {
                File dest = new File(mergedFolders.getViewFolder(), viewFolder.getName());
                if (dest.exists()) continue;
                FileUtils.moveDirectory((File)viewFolder, (File)dest);
            }
        }
    }

    public static StaticTestSelection mergePartFiles(File out, File[] partFiles, CommitComparatorInstance comparator) throws IOException, JsonGenerationException, JsonMappingException {
        List<StaticTestSelection> staticTestSelection = PartialSelectionResultsMerger.readStaticTestSelection(partFiles);
        StaticTestSelection merged = PartialSelectionResultsMerger.mergeDependencies(staticTestSelection, comparator);
        Constants.OBJECTMAPPER.writeValue(out, (Object)merged);
        return merged;
    }

    public static void mergeSelectionResults(File out, ResultsFolders[] partFolders, CommitComparatorInstance comparator) throws IOException, JsonGenerationException, JsonMappingException {
        File[] partFiles = new File[partFolders.length];
        for (int i = 0; i < partFolders.length; ++i) {
            partFiles[i] = partFolders[i].getStaticTestSelectionFile();
        }
        PartialSelectionResultsMerger.mergePartFiles(out, partFiles, comparator);
    }

    static List<StaticTestSelection> readStaticTestSelection(File[] partFiles) {
        LinkedList<StaticTestSelection> staticTestSelection = new LinkedList<StaticTestSelection>();
        for (int i = 0; i < partFiles.length; ++i) {
            try {
                LOG.debug("Reading: {}", (Object)partFiles[i]);
                StaticTestSelection currentStaticSelection = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(partFiles[i], StaticTestSelection.class);
                staticTestSelection.add(currentStaticSelection);
                LOG.debug("Size: {}", (Object)((StaticTestSelection)staticTestSelection.get(staticTestSelection.size() - 1)).getCommits().size());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return staticTestSelection;
    }

    public static StaticTestSelection mergeDependencies(List<StaticTestSelection> staticTestSelections, final CommitComparatorInstance comparator) {
        StaticTestSelection merged;
        LOG.debug("Sorting {} dependencies", (Object)staticTestSelections.size());
        staticTestSelections.sort(new Comparator<StaticTestSelection>(){

            @Override
            public int compare(StaticTestSelection o1, StaticTestSelection o2) {
                int indexOf = comparator.getVersionIndex(o1.getInitialcommit().getCommit());
                int indexOf2 = comparator.getVersionIndex(o2.getInitialcommit().getCommit());
                return indexOf - indexOf2;
            }
        });
        if (staticTestSelections.size() > 0) {
            merged = staticTestSelections.get(0);
            if (staticTestSelections.size() > 1) {
                for (int i = 1; i < staticTestSelections.size(); ++i) {
                    StaticTestSelection newMergedSelection = staticTestSelections.get(i);
                    LOG.debug("Merge: {} Vals: {}", (Object)i, (Object)newMergedSelection.getCommitNames());
                    if (newMergedSelection == null) continue;
                    merged = DependencyReaderUtil.mergeStaticSelection(merged, newMergedSelection, comparator);
                }
            }
        } else {
            merged = new StaticTestSelection();
        }
        return merged;
    }

    public static ExecutionData mergeExecutiondata(List<ExecutionData> executionData, CommitComparatorInstance comparator) {
        ExecutionData merged = new ExecutionData();
        for (ExecutionData data : executionData) {
            if (merged.getUrl() == null && data.getUrl() != null) {
                merged.setUrl(data.getUrl());
            }
            merged.getCommits().putAll(data.getCommits());
        }
        merged.sort(comparator);
        return merged;
    }

    public static ExecutionData mergeExecutions(ResultsFolders mergedOut, ResultsFolders[] outFiles, CommitComparatorInstance comparator) throws JsonParseException, JsonMappingException, IOException {
        LinkedList<File> executionOutFiles = new LinkedList<File>();
        LinkedList<File> coverageSelectionOutFiles = new LinkedList<File>();
        LinkedList<File> twiceExecutableOutFiles = new LinkedList<File>();
        for (ResultsFolders resultFolder : outFiles) {
            if (resultFolder == null) continue;
            if (resultFolder.getTraceTestSelectionFile().exists()) {
                executionOutFiles.add(resultFolder.getTraceTestSelectionFile());
            }
            if (resultFolder.getCoverageSelectionFile() != null && resultFolder.getCoverageSelectionFile().exists()) {
                coverageSelectionOutFiles.add(resultFolder.getCoverageSelectionFile());
            }
            if (resultFolder.getTwiceExecutableFile() == null || !resultFolder.getTwiceExecutableFile().exists()) continue;
            twiceExecutableOutFiles.add(resultFolder.getTwiceExecutableFile());
        }
        ExecutionData mergedExecutions = PartialSelectionResultsMerger.mergeExecutionFiles(executionOutFiles, comparator);
        Constants.OBJECTMAPPER.writeValue(mergedOut.getTraceTestSelectionFile(), (Object)mergedExecutions);
        if (coverageSelectionOutFiles.size() > 0) {
            ExecutionData mergedCoverage = PartialSelectionResultsMerger.mergeExecutionFiles(coverageSelectionOutFiles, comparator);
            Constants.OBJECTMAPPER.writeValue(mergedOut.getCoverageSelectionFile(), (Object)mergedCoverage);
        }
        if (twiceExecutableOutFiles.size() > 0) {
            ExecutionData mergedTwiceExecutable = PartialSelectionResultsMerger.mergeExecutionFiles(twiceExecutableOutFiles, comparator);
            Constants.OBJECTMAPPER.writeValue(mergedOut.getTwiceExecutableFile(), (Object)mergedTwiceExecutable);
        }
        return mergedExecutions;
    }

    private static ExecutionData mergeExecutionFiles(List<File> executionOutFiles, CommitComparatorInstance comparator) throws IOException {
        LinkedList<ExecutionData> executionData = new LinkedList<ExecutionData>();
        for (File file : executionOutFiles) {
            ExecutionData currentData = (ExecutionData)Constants.OBJECTMAPPER.readValue(file, ExecutionData.class);
            executionData.add(currentData);
        }
        ExecutionData merged = PartialSelectionResultsMerger.mergeExecutiondata(executionData, comparator);
        return merged;
    }
}

