/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ExecutionData
extends SelectedTests {
    private Map<String, TestSet> commits = new LinkedHashMap<String, TestSet>();

    public ExecutionData() {
    }

    public ExecutionData(StaticTestSelection dependencies) {
        this.setUrl(dependencies.getUrl());
        this.commits.put(dependencies.getInitialcommit().getCommit(), new TestSet());
        for (Map.Entry<String, CommitStaticSelection> commit : dependencies.getCommits().entrySet()) {
            TestSet tests = commit.getValue().getTests();
            this.commits.put(commit.getKey(), tests);
        }
    }

    public void setCommits(Map<String, TestSet> commits) {
        this.commits = commits;
    }

    public Map<String, TestSet> getCommits() {
        return this.commits;
    }

    @JsonIgnore
    public void addEmptyCommit(String commit, String predecessor) {
        TestSet tests = new TestSet();
        tests.setPredecessor(predecessor);
        this.commits.put(commit, tests);
    }

    @JsonIgnore
    public void addCall(String commit, TestSet tests) {
        TestSet executes = this.commits.get(commit);
        if (executes == null) {
            this.commits.put(commit, tests);
        } else {
            executes.addTestSet(tests);
        }
    }

    @JsonIgnore
    public void addCall(String commit, TestMethodCall testcase) {
        TestSet executes = this.commits.get(commit);
        if (executes == null) {
            executes = new TestSet();
            this.commits.put(commit, executes);
        }
        executes.addTest(testcase);
    }

    @JsonIgnore
    public boolean commitContainsTest(String commit, TestMethodCall currentIterationTest) {
        TestSet clazzExecutions = this.commits.get(commit);
        if (clazzExecutions != null) {
            for (Map.Entry<TestClazzCall, Set<String>> clazz : clazzExecutions.entrySet()) {
                TestCase testclazz = (TestCase)clazz.getKey();
                Set<String> methods = clazz.getValue();
                if (!testclazz.getClazz().equals(currentIterationTest.getClazz()) || !methods.contains(currentIterationTest.getMethod())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public void sort(CommitComparatorInstance comparator) {
        LinkedHashMap<String, TestSet> unsorted = new LinkedHashMap<String, TestSet>();
        Map<String, TestSet> map = this.commits;
        synchronized (map) {
            unsorted.putAll(this.commits);
            this.commits.clear();
            LinkedList commitNames = new LinkedList();
            commitNames.addAll(unsorted.keySet());
            Collections.sort(commitNames, comparator);
            for (String commit : commitNames) {
                this.commits.put(commit, (TestSet)unsorted.get(commit));
            }
        }
    }

    @JsonIgnore
    public int getAllExecutions() {
        int count2 = 0;
        for (Map.Entry<String, TestSet> entry : this.getCommits().entrySet()) {
            count2 += entry.getValue().getTestMethods().size();
        }
        return count2;
    }

    @Override
    @JsonIgnore
    public String[] getCommitNames() {
        return this.commits.keySet().toArray(new String[0]);
    }
}

