/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.serialization.TestMethodCallKeyDeserializer;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.InitialCallList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class InitialCommit {
    private String commit;
    @Deprecated
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String version;
    private int jdk = 8;
    private boolean running = true;
    @JsonDeserialize(keyUsing=TestMethodCallKeyDeserializer.class)
    private Map<TestMethodCall, InitialCallList> initialDependencies = new TreeMap<TestMethodCall, InitialCallList>();

    public String getCommit() {
        return this.commit;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = null;
        this.commit = version;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=IsRunningFilter.class)
    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Map<TestMethodCall, InitialCallList> getInitialDependencies() {
        return this.initialDependencies;
    }

    public void setInitialDependencies(Map<TestMethodCall, InitialCallList> initialDependencies) {
        this.initialDependencies = initialDependencies;
    }

    public int getJdk() {
        return this.jdk;
    }

    public void setJdk(int jdk) {
        this.jdk = jdk;
    }

    public void addDependency(TestMethodCall testcase, MethodCall callee) {
        InitialCallList dependency = this.initialDependencies.get(testcase);
        if (dependency == null) {
            dependency = new InitialCallList();
            this.initialDependencies.put(testcase, dependency);
        }
        dependency.getEntities().add(callee);
    }

    @JsonIgnore
    public void sort(TestCase key) {
        Collections.sort(this.initialDependencies.get(key).getEntities());
    }

    @JsonIgnore
    public TestSet getInitialTests() {
        TestSet initialTests = new TestSet();
        for (TestMethodCall testEntity : this.initialDependencies.keySet()) {
            initialTests.addTest(testEntity);
        }
        return initialTests;
    }

    private static final class IsRunningFilter {
        private IsRunningFilter() {
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Boolean)) {
                return false;
            }
            Boolean v = (Boolean)obj;
            return Boolean.TRUE.equals(v);
        }
    }
}

