/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.InitialCommit;
import de.dagere.peass.dependency.persistence.SelectedTests;
import java.util.LinkedHashMap;
import java.util.Map;

public class StaticTestSelection
extends SelectedTests {
    private String testGoal;
    private InitialCommit initialcommit = new InitialCommit();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private InitialCommit initialversion = null;
    private Map<String, CommitStaticSelection> commits = new LinkedHashMap<String, CommitStaticSelection>();

    public StaticTestSelection() {
    }

    public StaticTestSelection(ExecutionData executiondata) {
        this.setUrl(executiondata.getUrl());
        String first = executiondata.getCommits().keySet().iterator().next();
        this.initialcommit.setCommit(first);
        for (Map.Entry<String, TestSet> commit : executiondata.getCommits().entrySet()) {
            if (commit.getKey().equals(first)) continue;
            CommitStaticSelection commitDependencies = new CommitStaticSelection();
            commitDependencies.setPredecessor(commit.getValue().getPredecessor());
            commitDependencies.getChangedClazzes().put(new Type("unknown", ""), commit.getValue());
            String commitHash = commit.getKey();
            this.commits.put(commitHash, commitDependencies);
            for (TestMethodCall test : commit.getValue().getTestMethods()) {
                MethodCall testItself = new MethodCall(test.getClazz(), "", test.getMethod());
                this.initialcommit.addDependency(test, testItself);
            }
        }
    }

    public void setTestGoal(String testGoal) {
        this.testGoal = testGoal;
    }

    public String getTestGoal() {
        return this.testGoal;
    }

    @Deprecated
    public InitialCommit getInitialversion() {
        return this.initialversion;
    }

    @Deprecated
    public void setInitialversion(InitialCommit initialversion) {
        this.initialversion = initialversion;
    }

    public InitialCommit getInitialcommit() {
        if (this.initialversion != null) {
            this.initialcommit = this.initialversion;
            this.initialversion = null;
        }
        return this.initialcommit;
    }

    public void setInitialcommit(InitialCommit initialversion) {
        this.initialcommit = initialversion;
    }

    public Map<String, CommitStaticSelection> getCommits() {
        return this.commits;
    }

    public void setCommits(Map<String, CommitStaticSelection> versions) {
        this.commits = versions;
    }

    @Override
    @JsonIgnore
    public String[] getCommitNames() {
        String[] commitNames = this.commits.keySet().toArray(new String[0]);
        String[] withStartcommit = new String[commitNames.length + 1];
        withStartcommit[0] = this.initialcommit.getCommit();
        System.arraycopy(commitNames, 0, withStartcommit, 1, commitNames.length);
        return withStartcommit;
    }

    @JsonIgnore
    public String getNewestCommit() {
        String[] commits = this.getCommitNames();
        if (commits.length > 0) {
            return commits[commits.length - 1];
        }
        if (this.initialcommit != null) {
            return this.initialcommit.getCommit();
        }
        return null;
    }

    @JsonIgnore
    public String[] getRunningCommitNames() {
        String[] commitNames = (String[])this.commits.entrySet().stream().filter(entry -> ((CommitStaticSelection)entry.getValue()).isRunning()).map(entry -> (String)entry.getKey()).toArray(String[]::new);
        String[] withStartcommit = new String[commitNames.length + 1];
        withStartcommit[0] = this.initialcommit.getCommit();
        System.arraycopy(commitNames, 0, withStartcommit, 1, commitNames.length);
        return withStartcommit;
    }

    @JsonIgnore
    public String getNewestRunningCommit() {
        String[] commits = this.getRunningCommitNames();
        if (commits.length > 0) {
            return commits[commits.length - 1];
        }
        if (this.initialcommit != null) {
            return this.initialcommit.getCommit();
        }
        return null;
    }

    @JsonIgnore
    public ExecutionData toExecutionData() {
        ExecutionData executionData = new ExecutionData();
        for (Map.Entry<String, CommitStaticSelection> entry : this.commits.entrySet()) {
            TestSet tests = entry.getValue().getTests();
            executionData.getCommits().put(entry.getKey(), tests);
        }
        return executionData;
    }
}

