/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommitKeeper {
    public static final CommitKeeper INSTANCE = new CommitKeeper();
    @JsonIgnore
    private final File goal;
    Map<String, String> nonRunableReasons = new LinkedHashMap<String, String>();

    private CommitKeeper() {
        this.goal = new File("/dev/null");
    }

    public CommitKeeper(File goal) {
        this.goal = goal;
    }

    public Map<String, String> getNonRunableReasons() {
        return this.nonRunableReasons;
    }

    public void setNonRunableReasons(Map<String, String> nonRunableReasons) {
        this.nonRunableReasons = nonRunableReasons;
    }

    @JsonIgnore
    public synchronized void addCommit(String commit, String reason) {
        this.nonRunableReasons.put(commit, reason);
        try {
            Constants.OBJECTMAPPER.writeValue(this.goal, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

