/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.TestSelectionConfig;
import de.dagere.peass.dependency.parallel.OneReader;
import de.dagere.peass.dependency.reader.CommitKeeper;
import de.dagere.peass.dependency.reader.DependencyReader;
import de.dagere.peass.dependency.reader.RunningCommitFinder;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.vcs.CommitIterator;
import de.dagere.peass.vcs.CommitIteratorGit;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DependencyParallelReader {
    private static final Logger LOG = LogManager.getLogger(DependencyParallelReader.class);
    private final TestSelectionConfig dependencyConfig;
    private final String url;
    private final CommitKeeper nonRunning;
    private final CommitKeeper nonChanges;
    private final CommitComparatorInstance comparator;
    private final PeassFolders folders;
    private final int sizePerThread;
    private final ResultsFolders[] outFolders;
    private final File tempResultFolder;
    private final String project;
    private final ExecutionConfig executionConfig;
    private final KiekerConfig kiekerConfig;
    private final EnvironmentVariables env;

    public DependencyParallelReader(File projectFolder, File resultBaseFolder, String project, CommitComparatorInstance commits, TestSelectionConfig dependencyConfig, ExecutionConfig executionConfig, KiekerConfig kiekerConfig, EnvironmentVariables env) {
        this.url = GitUtils.getURL(projectFolder);
        this.dependencyConfig = dependencyConfig;
        this.executionConfig = executionConfig;
        this.kiekerConfig = kiekerConfig;
        LOG.debug(this.url);
        this.folders = new PeassFolders(projectFolder);
        this.comparator = commits;
        this.project = project;
        this.env = env;
        this.tempResultFolder = new File(resultBaseFolder, "temp_" + project);
        if (!this.tempResultFolder.exists()) {
            this.tempResultFolder.mkdirs();
        }
        LOG.info("Writing to: {}", (Object)this.tempResultFolder.getAbsolutePath());
        this.nonRunning = new CommitKeeper(new File(this.tempResultFolder, "nonRunning_" + project + ".json"));
        this.nonChanges = new CommitKeeper(new File(this.tempResultFolder, "nonChanges_" + project + ".json"));
        this.sizePerThread = commits.getCommits().size() > 2 * dependencyConfig.getThreads() ? commits.getCommits().size() / dependencyConfig.getThreads() : 2;
        this.outFolders = commits.getCommits().size() > 2 * dependencyConfig.getThreads() ? new ResultsFolders[dependencyConfig.getThreads()] : new ResultsFolders[1];
        LOG.debug("Threads: {} Size per Thread: {} OutFile: {}", (Object)dependencyConfig.getThreads(), (Object)this.sizePerThread, (Object)this.outFolders.length);
    }

    public ResultsFolders[] readDependencies() throws InterruptedException, IOException {
        ExecutorService service = Executors.newFixedThreadPool(this.outFolders.length, new ThreadFactory(){
            int threadcount = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                ++this.threadcount;
                return new Thread(runnable, "dependencypool-" + this.threadcount);
            }
        });
        this.startAllProcesses(service);
        service.shutdown();
        this.waitForAll(service);
        return this.outFolders;
    }

    private void startAllProcesses(ExecutorService service) throws IOException, InterruptedException {
        for (int outfileIndex = 0; outfileIndex < this.outFolders.length; ++outfileIndex) {
            int readableIndex = outfileIndex + 1;
            this.outFolders[outfileIndex] = new ResultsFolders(new File(this.tempResultFolder, "temp_" + this.project + "_" + readableIndex), this.project);
            PeassFolders foldersTemp = this.folders.getTempFolder("" + readableIndex, this.executionConfig.getGitCryptKey());
            ResultsFolders currentOutFile = this.outFolders[outfileIndex];
            this.startPartProcess(currentOutFile, service, outfileIndex, foldersTemp);
        }
    }

    private void waitForAll(ExecutorService service) {
        try {
            LOG.debug("Wait for finish");
            boolean success = service.awaitTermination(Long.MAX_VALUE, TimeUnit.HOURS);
            LOG.debug("Finished Reading: {} - {}", (Object)success, (Object)service.isTerminated());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void startPartProcess(ResultsFolders currentOutFolders, ExecutorService service, int outfileIndex, PeassFolders foldersTemp) throws InterruptedException {
        int min = outfileIndex * this.sizePerThread;
        int max = Math.min((outfileIndex + 1) * this.sizePerThread + 1, this.comparator.getCommits().size());
        LOG.debug("Min: {} Max: {} Size: {}", (Object)min, (Object)max, (Object)this.comparator.getCommits().size());
        List<String> currentCommits = this.comparator.getCommits().subList(min, max);
        List<String> reserveCommits = this.comparator.getCommits().subList(max - 1, this.comparator.getCommits().size());
        String minimumCommit = this.comparator.getCommits().get(Math.min(max, this.comparator.getCommits().size() - 1));
        if (currentCommits.size() > 0) {
            this.processCommits(currentOutFolders, service, foldersTemp, currentCommits, reserveCommits, minimumCommit);
        }
    }

    void processCommits(ResultsFolders currentOutFolders, ExecutorService service, PeassFolders foldersTemp, List<String> currentCommits, List<String> reserveCommits, String minimumCommit) throws InterruptedException {
        LOG.debug("Start: {} End: {}", (Object)currentCommits.get(0), (Object)currentCommits.get(currentCommits.size() - 1));
        LOG.debug(currentCommits);
        CommitIteratorGit iterator = new CommitIteratorGit(foldersTemp.getProjectFolder(), currentCommits, null);
        RunningCommitFinder finder = new RunningCommitFinder(foldersTemp, this.nonRunning, iterator, this.executionConfig, this.env);
        DependencyReader reader = new DependencyReader(this.dependencyConfig, foldersTemp, currentOutFolders, this.url, (CommitIterator)iterator, this.nonChanges, this.executionConfig, this.kiekerConfig, this.env);
        CommitIteratorGit reserveIterator = new CommitIteratorGit(foldersTemp.getProjectFolder(), reserveCommits, null);
        OneReader current = new OneReader(minimumCommit, reserveIterator, reader, finder, this.comparator);
        service.submit(current);
        Thread.sleep(5L);
    }
}

