/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import com.github.javaparser.ParseException;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.TestSelectionConfig;
import de.dagere.peass.dependency.ChangeManager;
import de.dagere.peass.dependency.DependencyManager;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependency.reader.CommitKeeper;
import de.dagere.peass.dependency.reader.DependencyReaderUtil;
import de.dagere.peass.dependency.reader.DependencyReadingInput;
import de.dagere.peass.dependency.reader.DependencySizeRecorder;
import de.dagere.peass.dependency.reader.InitialCommitReader;
import de.dagere.peass.dependency.reader.OldTraceReader;
import de.dagere.peass.dependency.reader.StaticChangeHandler;
import de.dagere.peass.dependency.reader.TooBigLogCleaner;
import de.dagere.peass.dependency.reader.TraceChangeHandler;
import de.dagere.peass.dependency.reader.TraceViewGenerator;
import de.dagere.peass.dependency.reader.twiceExecution.TwiceExecutableChecker;
import de.dagere.peass.dependency.traces.TraceFileMapping;
import de.dagere.peass.dependency.traces.coverage.CoverageSelectionExecutor;
import de.dagere.peass.dependency.traces.coverage.CoverageSelectionInfo;
import de.dagere.peass.dependency.traces.diff.DiffFileGenerator;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.CommitIterator;
import de.dagere.peass.vcs.GitCommitWriter;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DependencyReader {
    private static final Logger LOG = LogManager.getLogger(DependencyReader.class);
    private final TestSelectionConfig testSelectionConfig;
    protected final StaticTestSelection staticSelectionResult = new StaticTestSelection();
    private final ExecutionData executionResult = new ExecutionData();
    private final ExecutionData coverageBasedSelection = new ExecutionData();
    private final CoverageSelectionInfo coverageSelectionInfo = new CoverageSelectionInfo();
    private final ExecutionData twiceExecutableSelected = new ExecutionData();
    private final CoverageSelectionExecutor coverageExecutor;
    private final TwiceExecutableChecker twiceExecutableChecker;
    protected final ResultsFolders resultsFolders;
    protected final PeassFolders folders;
    protected CommitIterator iterator;
    protected String lastRunningVersion;
    private final CommitKeeper skippedNoChange;
    private final KiekerConfig kiekerConfig;
    private final ExecutionConfig executionConfig;
    private final EnvironmentVariables env;
    protected final DependencyManager dependencyManager;
    private ChangeManager changeManager;
    private StaticChangeHandler staticChangeHandler;
    private final DependencySizeRecorder sizeRecorder = new DependencySizeRecorder();
    private final TraceFileMapping traceFileMapping = new TraceFileMapping();

    public DependencyReader(TestSelectionConfig dependencyConfig, PeassFolders folders, ResultsFolders resultsFolders, String url, CommitIterator iterator, ChangeManager changeManager, ExecutionConfig executionConfig, KiekerConfig kiekerConfig, EnvironmentVariables env) {
        this.testSelectionConfig = dependencyConfig;
        this.resultsFolders = resultsFolders;
        this.iterator = iterator;
        this.folders = folders;
        this.skippedNoChange = new CommitKeeper(new File("/dev/null"));
        this.executionConfig = executionConfig;
        this.kiekerConfig = kiekerConfig;
        this.env = env;
        this.setURLs(url);
        this.dependencyManager = new DependencyManager(folders, executionConfig, kiekerConfig, env);
        this.coverageExecutor = new CoverageSelectionExecutor(this.traceFileMapping, this.coverageBasedSelection, this.coverageSelectionInfo);
        this.twiceExecutableChecker = new TwiceExecutableChecker(this.getExecutor(), this.twiceExecutableSelected);
        this.changeManager = changeManager;
        if (!kiekerConfig.isUseKieker()) {
            throw new RuntimeException("Dependencies may only be read if Kieker is enabled!");
        }
    }

    private void setURLs(String url) {
        this.staticSelectionResult.setUrl(url);
        this.executionResult.setUrl(url);
        this.coverageBasedSelection.setUrl(url);
        this.twiceExecutableSelected.setUrl(url);
    }

    public DependencyReader(TestSelectionConfig dependencyConfig, PeassFolders folders, ResultsFolders resultsFolders, String url, CommitIterator iterator, CommitKeeper skippedNoChange, ExecutionConfig executionConfig, KiekerConfig kiekerConfig, EnvironmentVariables env) {
        this.testSelectionConfig = dependencyConfig;
        this.resultsFolders = resultsFolders;
        this.iterator = iterator;
        this.folders = folders;
        this.skippedNoChange = skippedNoChange;
        this.executionConfig = executionConfig;
        this.kiekerConfig = kiekerConfig;
        this.env = env;
        this.setURLs(url);
        this.dependencyManager = new DependencyManager(folders, executionConfig, kiekerConfig, env);
        this.coverageExecutor = new CoverageSelectionExecutor(this.traceFileMapping, this.coverageBasedSelection, this.coverageSelectionInfo);
        this.twiceExecutableChecker = new TwiceExecutableChecker(this.getExecutor(), this.twiceExecutableSelected);
        if (!kiekerConfig.isUseKieker()) {
            throw new RuntimeException("Dependencies may only be read if Kieker is enabled!");
        }
    }

    public boolean readDependencies() {
        try {
            LOG.debug("Analysing {} entries", (Object)this.iterator.getRemainingSize());
            this.sizeRecorder.setPrunedSize(this.dependencyManager.getDependencyMap().size());
            this.changeManager.saveOldClasses();
            this.lastRunningVersion = this.iterator.getCommitName();
            while (this.iterator.hasNextCommit()) {
                this.iterator.goToNextCommit();
                this.readCommit();
            }
            LOG.debug("Finished dependency-reading");
            return true;
        }
        catch (ParseException | IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void readCommit() throws IOException, InterruptedException, ParseException {
        int tests = this.analyseCommit(this.changeManager);
        GitCommitWriter.writeCurrentCommits(this.folders, this.iterator.getCommits(), this.resultsFolders);
        DependencyReaderUtil.write(this.staticSelectionResult, this.resultsFolders.getStaticTestSelectionFile());
        if (this.testSelectionConfig.isGenerateTraces()) {
            Constants.OBJECTMAPPER.writeValue(this.resultsFolders.getTraceTestSelectionFile(), (Object)this.executionResult);
            if (this.testSelectionConfig.isGenerateCoverageSelection()) {
                Constants.OBJECTMAPPER.writeValue(this.resultsFolders.getCoverageSelectionFile(), (Object)this.coverageBasedSelection);
                Constants.OBJECTMAPPER.writeValue(this.resultsFolders.getCoverageInfoFile(), (Object)this.coverageSelectionInfo);
            }
            if (this.testSelectionConfig.isGenerateTwiceExecutability()) {
                Constants.OBJECTMAPPER.writeValue(this.resultsFolders.getTwiceExecutableFile(), (Object)this.twiceExecutableSelected);
            }
        }
        this.sizeRecorder.addVersionSize(this.dependencyManager.getDependencyMap().size(), tests);
        this.dependencyManager.getExecutor().deleteTemporaryFiles();
        TooBigLogCleaner.cleanJSONFolder(this.folders);
        TooBigLogCleaner.cleanTooBigLogs(this.folders, this.iterator.getCommitName());
    }

    public int analyseCommit(ChangeManager changeManager) throws IOException, ParseException {
        String commit = this.iterator.getCommitName();
        if (!this.testSelectionConfig.isSkipProcessSuccessRuns() && !this.dependencyManager.getExecutor().isCommitRunning(this.iterator.getCommitName())) {
            this.documentFailure(commit);
            return 0;
        }
        this.dependencyManager.getExecutor().loadClasses();
        DependencyReadingInput input = new DependencyReadingInput(changeManager.getChanges(this.lastRunningVersion), this.lastRunningVersion);
        changeManager.saveOldClasses();
        this.lastRunningVersion = this.iterator.getCommitName();
        if (this.executionConfig.isCreateDetailDebugFiles()) {
            Constants.OBJECTMAPPER.writeValue(new File(this.folders.getDebugFolder(), "initialdependencies_" + commit + ".json"), (Object)this.dependencyManager.getDependencyMap());
            Constants.OBJECTMAPPER.writeValue(new File(this.folders.getDebugFolder(), "changes_" + commit + ".json"), input.getChanges());
        }
        if (input.getChanges().size() > 0) {
            return this.analyseChanges(commit, input);
        }
        this.addEmptyCommitData(commit, input);
        return 0;
    }

    private void addEmptyCommitData(String commit, DependencyReadingInput input) {
        CommitStaticSelection emptyCommit = new CommitStaticSelection();
        emptyCommit.setJdk(this.dependencyManager.getExecutor().getJDKVersion());
        emptyCommit.setRunning(true);
        emptyCommit.setPredecessor(input.getPredecessor());
        this.staticSelectionResult.getCommits().put(commit, emptyCommit);
        if (this.testSelectionConfig.isGenerateTraces()) {
            this.executionResult.addEmptyCommit(commit, null);
            this.coverageBasedSelection.addEmptyCommit(commit, null);
        }
        if (this.testSelectionConfig.isGenerateTwiceExecutability()) {
            this.twiceExecutableSelected.addEmptyCommit(commit, null);
        }
        this.skippedNoChange.addCommit(commit, "No Change at all");
    }

    private int analyseChanges(String commit, DependencyReadingInput input) throws IOException, ParseException {
        CommitStaticSelection newCommitInfo = this.staticChangeHandler.handleStaticAnalysisChanges(commit, input, this.dependencyManager.getModuleClassMapping());
        if (!this.testSelectionConfig.isDoNotUpdateDependencies()) {
            TraceChangeHandler traceChangeHandler = new TraceChangeHandler(this.dependencyManager, this.folders, this.executionConfig, commit);
            traceChangeHandler.handleTraceAnalysisChanges(newCommitInfo);
            if (this.testSelectionConfig.isGenerateTraces()) {
                this.generateTraces(commit, newCommitInfo);
                this.deriveAdditionalTestProperties(commit, newCommitInfo);
            }
        } else {
            LOG.debug("Not updating dependencies since doNotUpdateDependencies was set - only returning dependencies based on changed classes");
        }
        this.staticSelectionResult.getCommits().put(commit, newCommitInfo);
        int changedClazzCount = this.calculateChangedClassCount(newCommitInfo);
        return changedClazzCount;
    }

    private void deriveAdditionalTestProperties(String commit, CommitStaticSelection newCommitInfo) throws IOException {
        TestSet dynamicallySelected = this.executionResult.getCommits().get(commit);
        if (this.testSelectionConfig.isGenerateTwiceExecutability()) {
            this.twiceExecutableChecker.checkTwiceExecution(commit, newCommitInfo.getPredecessor(), dynamicallySelected.getTestMethods());
            dynamicallySelected = this.twiceExecutableSelected.getCommits().get(commit);
            LOG.info("Left after twice execution checking: {}", (Object)dynamicallySelected);
        }
        if (this.testSelectionConfig.isGenerateCoverageSelection()) {
            this.coverageExecutor.generateCoverageBasedSelection(commit, newCommitInfo, dynamicallySelected);
        }
    }

    private void generateTraces(String commit, CommitStaticSelection newCommitInfo) throws IOException, ParseException {
        this.executionResult.addEmptyCommit(commit, newCommitInfo.getPredecessor());
        this.coverageBasedSelection.addEmptyCommit(commit, newCommitInfo.getPredecessor());
        TraceViewGenerator traceViewGenerator = new TraceViewGenerator(this.dependencyManager, this.folders, commit, this.traceFileMapping, this.kiekerConfig, this.testSelectionConfig);
        traceViewGenerator.generateViews(this.resultsFolders, newCommitInfo.getTests());
        DiffFileGenerator diffGenerator = new DiffFileGenerator(this.resultsFolders.getCommitDiffFolder(commit));
        diffGenerator.generateAllDiffs(commit, newCommitInfo, this.traceFileMapping, this.executionResult);
    }

    private int calculateChangedClassCount(CommitStaticSelection newCommitInfo) {
        int changedClazzCount = newCommitInfo.getChangedClazzes().values().stream().mapToInt(value -> value.getTestcases().values().stream().mapToInt(list -> list.size()).sum()).sum();
        return changedClazzCount;
    }

    public void documentFailure(String commit) {
        if (this.dependencyManager.getExecutor().isAndroid()) {
            this.staticSelectionResult.setAndroid(true);
            this.executionResult.setAndroid(true);
            this.coverageBasedSelection.setAndroid(true);
        }
        LOG.error("Commit not running");
        CommitStaticSelection newCommitInfo = new CommitStaticSelection();
        newCommitInfo.setRunning(false);
        this.staticSelectionResult.getCommits().put(commit, newCommitInfo);
    }

    public boolean readInitialCommit() throws IOException, ParseException {
        this.changeManager = new ChangeManager(this.folders, this.iterator, this.executionConfig, this.dependencyManager.getExecutor());
        this.staticChangeHandler = new StaticChangeHandler(this.folders, this.executionConfig, this.dependencyManager);
        InitialCommitReader initialVersionReader = new InitialCommitReader(this.staticSelectionResult, this.dependencyManager, this.iterator);
        if (initialVersionReader.readInitialCommit()) {
            DependencyReaderUtil.write(this.staticSelectionResult, this.resultsFolders.getStaticTestSelectionFile());
            this.lastRunningVersion = this.iterator.getCommitName();
            if (this.testSelectionConfig.isGenerateTraces()) {
                this.generateInitialViews();
            }
            this.dependencyManager.cleanResultFolder();
            return true;
        }
        return false;
    }

    private void generateInitialViews() throws IOException, ParseException {
        TestSet initialTests = this.staticSelectionResult.getInitialcommit().getInitialTests();
        TraceViewGenerator traceViewGenerator = new TraceViewGenerator(this.dependencyManager, this.folders, this.iterator.getCommitName(), this.traceFileMapping, this.kiekerConfig, this.testSelectionConfig);
        traceViewGenerator.generateViews(this.resultsFolders, initialTests);
        this.executionResult.getCommits().put(this.iterator.getCommitName(), new TestSet());
        this.coverageBasedSelection.getCommits().put(this.iterator.getCommitName(), new TestSet());
        this.twiceExecutableSelected.getCommits().put(this.iterator.getCommitName(), new TestSet());
    }

    public void readCompletedCommits(StaticTestSelection initialdependencies, CommitComparatorInstance comparator) {
        this.changeManager = new ChangeManager(this.folders, this.iterator, this.executionConfig, this.dependencyManager.getExecutor());
        this.staticChangeHandler = new StaticChangeHandler(this.folders, this.executionConfig, this.dependencyManager);
        this.staticSelectionResult.setCommits(initialdependencies.getCommits());
        this.staticSelectionResult.setInitialcommit(initialdependencies.getInitialcommit());
        InitialCommitReader initialCommitReader = new InitialCommitReader(initialdependencies, this.dependencyManager, this.iterator);
        initialCommitReader.readCompletedCommits(comparator);
        DependencyReaderUtil.write(this.staticSelectionResult, this.resultsFolders.getStaticTestSelectionFile());
        this.lastRunningVersion = this.iterator.getCommitName();
    }

    public StaticTestSelection getDependencies() {
        return this.staticSelectionResult;
    }

    public ExecutionData getExecutionResult() {
        return this.executionResult;
    }

    public ExecutionData getCoverageBasedSelection() {
        return this.coverageBasedSelection;
    }

    public void setIterator(CommitIterator reserveIterator) {
        this.iterator = reserveIterator;
    }

    public void setCoverageExecutions(ExecutionData coverageExecutions) {
        this.coverageBasedSelection.setUrl(coverageExecutions.getUrl());
        this.coverageBasedSelection.setCommits(coverageExecutions.getCommits());
    }

    public void setExecutionData(ExecutionData executions) {
        this.executionResult.setUrl(executions.getUrl());
        this.executionResult.setCommits(executions.getCommits());
        new OldTraceReader(this.traceFileMapping, this.staticSelectionResult, this.resultsFolders).addTraces();
    }

    public void setCoverageInfo(CoverageSelectionInfo coverageInfo) {
        this.coverageSelectionInfo.getCommits().putAll(coverageInfo.getCommits());
    }

    public TestExecutor getExecutor() {
        return this.dependencyManager.getExecutor();
    }
}

