/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.diffDetection.ClazzChangeData;
import de.dagere.peass.dependency.analysis.data.ChangeTestMapping;
import de.dagere.peass.dependency.analysis.data.TestExistenceChanges;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DependencyReaderUtil {
    private static final Logger LOG = LogManager.getLogger(DependencyReaderUtil.class);

    static void removeDeletedTestcases(CommitStaticSelection newCommitSelection, TestExistenceChanges testExistenceChanges) {
        LOG.debug("Removed Tests: {}", testExistenceChanges.getRemovedTests());
        for (TestCase removedTest : testExistenceChanges.getRemovedTests()) {
            LOG.debug("Remove: {}", (Object)removedTest);
            for (Map.Entry<Type, TestSet> dependency : newCommitSelection.getChangedClazzes().entrySet()) {
                TestSet testSet = dependency.getValue();
                if (removedTest instanceof TestMethodCall) {
                    for (Map.Entry<TestClazzCall, Set<String>> testcase : testSet.getTestcases().entrySet()) {
                        if (!testcase.getKey().getClazz().equals(removedTest.getClazz())) continue;
                        String method = ((TestMethodCall)removedTest).getMethod();
                        testcase.getValue().remove(method);
                    }
                    continue;
                }
                TestClazzCall removeTestcase = null;
                for (Map.Entry<TestClazzCall, Set<String>> testcase : testSet.getTestcases().entrySet()) {
                    if (!testcase.getKey().getClazz().equals(removedTest.getClazz())) continue;
                    removeTestcase = testcase.getKey();
                }
                if (removeTestcase == null) continue;
                testSet.removeTest(removeTestcase);
            }
        }
    }

    static void addNewTestcases(CommitStaticSelection newVersionInfo, Map<Type, Set<TestMethodCall>> newTestcases) {
        for (Map.Entry<Type, Set<TestMethodCall>> newTestcase : newTestcases.entrySet()) {
            Type changedClazz = newTestcase.getKey();
            TestSet testsetForChange = null;
            for (Map.Entry<Type, TestSet> dependency : newVersionInfo.getChangedClazzes().entrySet()) {
                Type dependencyChangedClazz = dependency.getKey();
                if (!dependencyChangedClazz.equals((Object)changedClazz)) continue;
                testsetForChange = dependency.getValue();
            }
            if (testsetForChange == null) {
                testsetForChange = new TestSet();
                newVersionInfo.getChangedClazzes().put(changedClazz, testsetForChange);
            }
            for (TestMethodCall testcase : newTestcase.getValue()) {
                testsetForChange.addTest(testcase.onlyClazz(), testcase.getMethod());
            }
        }
    }

    static CommitStaticSelection createCommitFromChangeMap(Map<Type, ClazzChangeData> changedClassNames, ChangeTestMapping changeTestMap) {
        CommitStaticSelection newCommitSelection = new CommitStaticSelection();
        newCommitSelection.setRunning(true);
        LOG.debug("Beginning to write");
        for (Map.Entry<Type, ClazzChangeData> changedClassName : changedClassNames.entrySet()) {
            ClazzChangeData changedClazzInsideFile = changedClassName.getValue();
            if (!changedClazzInsideFile.isOnlyMethodChange()) {
                DependencyReaderUtil.handleWholeClassChange(changeTestMap, newCommitSelection, changedClazzInsideFile);
                continue;
            }
            DependencyReaderUtil.handleMethodChange(changeTestMap, newCommitSelection, changedClazzInsideFile);
        }
        return newCommitSelection;
    }

    private static void handleMethodChange(ChangeTestMapping changeTestMap, CommitStaticSelection version, ClazzChangeData changedClassName) {
        for (Type underminedChange : changedClassName.getChanges()) {
            boolean contained = false;
            for (Map.Entry<Type, TestSet> currentDependency : version.getChangedClazzes().entrySet()) {
                if (!currentDependency.getKey().equals((Object)underminedChange)) continue;
                contained = true;
            }
            if (contained) continue;
            TestSet tests = new TestSet();
            if (changeTestMap.getChanges().containsKey(underminedChange)) {
                for (TestMethodCall testClass : changeTestMap.getChanges().get(underminedChange)) {
                    tests.addTest(testClass);
                }
            }
            version.getChangedClazzes().put(underminedChange, tests);
        }
    }

    private static void handleWholeClassChange(ChangeTestMapping changeTestMap, CommitStaticSelection version, ClazzChangeData changedClassName) {
        for (Type underminedChange : changedClassName.getUniqueChanges()) {
            TestSet tests = new TestSet();
            Type realChange = underminedChange.onlyClazz();
            Set<TestMethodCall> testEntities = changeTestMap.getTests(realChange);
            if (testEntities != null) {
                for (TestMethodCall testcase : testEntities) {
                    tests.addTest(testcase);
                }
            }
            if (version.getChangedClazzes().containsKey(realChange)) {
                throw new RuntimeException("Clazz FQNs are unique in Java, but " + realChange.getJavaClazzName() + " was added twice!");
            }
            version.getChangedClazzes().put(realChange, tests);
        }
    }

    public static void write(StaticTestSelection staticTestSelection, File file) {
        LOG.debug("Writing to: {}", (Object)file);
        try {
            Constants.OBJECTMAPPER.writeValue(file, (Object)staticTestSelection);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static StaticTestSelection mergeStaticSelection(StaticTestSelection staticTestSelection1, StaticTestSelection staticTestSelection2, CommitComparatorInstance comparator) {
        StaticTestSelection newer;
        StaticTestSelection merged;
        if (comparator.isBefore(staticTestSelection1.getInitialcommit().getCommit(), staticTestSelection2.getInitialcommit().getCommit())) {
            merged = staticTestSelection1;
            newer = staticTestSelection2;
        } else {
            newer = staticTestSelection1;
            merged = staticTestSelection2;
        }
        LOG.debug("Merging: {}", (Object)merged.getCommits().size());
        LinkedList<String> removableCommits = new LinkedList<String>();
        String commitInBoth = null;
        Iterator<String> iterator = newer.getCommits().keySet().iterator();
        if (iterator.hasNext()) {
            String firstOtherCommit = iterator.next();
            for (String string : merged.getCommits().keySet()) {
                if (merged == null && string.equals(firstOtherCommit) || comparator.isBefore(firstOtherCommit, string)) {
                    commitInBoth = string;
                }
                if (commitInBoth == null) continue;
                removableCommits.add(string);
            }
        } else {
            return merged;
        }
        LOG.debug("Removable: " + removableCommits.size());
        for (String commit : removableCommits) {
            LOG.debug("Removing: {}", (Object)commit);
            merged.getCommits().remove(commit);
        }
        int add = 0;
        for (Map.Entry entry : newer.getCommits().entrySet()) {
            LOG.debug("Add: {}", entry.getKey());
            ++add;
            merged.getCommits().put((String)entry.getKey(), (CommitStaticSelection)entry.getValue());
        }
        LOG.debug("Added: {} Size: {}", (Object)add, (Object)merged.getCommits().size());
        return merged;
    }
}

