/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.dependency.DependencyManager;
import de.dagere.peass.dependency.analysis.data.CalledMethods;
import de.dagere.peass.dependency.analysis.data.TestDependencies;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.InitialCallList;
import de.dagere.peass.dependency.persistence.InitialCommit;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.vcs.CommitIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitialCommitReader {
    private static final Logger LOG = LogManager.getLogger(InitialCommitReader.class);
    protected final StaticTestSelection dependencyResult;
    protected DependencyManager dependencyManager;
    protected CommitIterator iterator;
    protected TestDependencies dependencyMap;

    public InitialCommitReader(StaticTestSelection dependencyResult, DependencyManager dependencyManager, CommitIterator iterator) {
        this.dependencyResult = dependencyResult;
        this.dependencyManager = dependencyManager;
        this.iterator = iterator;
        this.dependencyMap = dependencyManager.getDependencyMap();
    }

    public boolean readInitialCommit() throws IOException {
        if (!this.dependencyManager.initialyGetTraces(this.iterator.getCommitName())) {
            return false;
        }
        InitialCommit initialcommit = this.createInitialCommit();
        this.dependencyResult.setInitialcommit(initialcommit);
        return true;
    }

    private InitialCommit createInitialCommit() {
        int jdkversion = this.dependencyManager.getExecutor().getJDKVersion();
        InitialCommit initialversion = new InitialCommit();
        initialversion.setCommit(this.iterator.getCommitName());
        initialversion.setJdk(jdkversion);
        LOG.debug("Starting writing: {}", (Object)this.dependencyMap.getDependencyMap().size());
        for (Map.Entry<TestMethodCall, CalledMethods> dependencyEntry : this.dependencyMap.getDependencyMap().entrySet()) {
            TestMethodCall testcase = dependencyEntry.getKey();
            for (Map.Entry<Type, Set<String>> calledClassEntry : dependencyEntry.getValue().getCalledMethods().entrySet()) {
                Type dependentclass = calledClassEntry.getKey();
                if (dependentclass.getJavaClazzName().contains("junit") || dependentclass.getJavaClazzName().contains("log4j")) continue;
                for (String dependentmethod : calledClassEntry.getValue()) {
                    MethodCall callee = new MethodCall(dependentclass.getClazz(), dependentclass.getModule(), dependentmethod);
                    initialversion.addDependency(testcase, callee);
                }
            }
            initialversion.sort((TestCase)testcase);
        }
        return initialversion;
    }

    public void readCompletedCommits(CommitComparatorInstance comparator) {
        this.fillInitialTestDependencies();
        this.checkCorrectness();
        InitialCommit initialcommit = this.createInitialCommit();
        this.dependencyResult.setInitialcommit(initialcommit);
        if (this.dependencyResult.getCommits().size() > 0) {
            String startCommitName = this.iterator.getCommitName();
            for (Map.Entry<String, CommitStaticSelection> commit : this.dependencyResult.getCommits().entrySet()) {
                String commitName = commit.getKey();
                LOG.debug("Adding {}", (Object)commitName);
                if (!comparator.isBefore(commitName, startCommitName) && !commitName.equals(startCommitName)) continue;
                this.addCommitTestDependencies(commit.getValue());
            }
        }
        this.checkCorrectness();
        LOG.debug("Analyzing {} commits", (Object)this.iterator.getRemainingSize());
    }

    private void addCommitTestDependencies(CommitStaticSelection commitStaticSelection) {
        if (commitStaticSelection.getChangedClazzes() != null) {
            for (Map.Entry<Type, TestSet> dependency : commitStaticSelection.getChangedClazzes().entrySet()) {
                Type callee = dependency.getKey();
                for (Map.Entry<TestClazzCall, Set<String>> testcase : dependency.getValue().getTestcases().entrySet()) {
                    for (String testMethod : testcase.getValue()) {
                        HashMap<Type, Set<String>> calledClasses = new HashMap<Type, Set<String>>();
                        HashSet<String> methods = new HashSet<String>();
                        methods.add(callee instanceof MethodCall ? ((MethodCall)callee).getMethod() : "");
                        calledClasses.put(new Type(callee.getClazz(), callee.getModule()), methods);
                        TestCase testClazz = (TestCase)testcase.getKey();
                        TestMethodCall test = new TestMethodCall(testClazz.getClazz(), testMethod, testClazz.getModule());
                        this.dependencyManager.addDependencies(test, calledClasses);
                    }
                }
            }
        }
    }

    private void fillInitialTestDependencies() {
        for (Map.Entry<TestMethodCall, InitialCallList> dependency : this.dependencyResult.getInitialcommit().getInitialDependencies().entrySet()) {
            for (MethodCall dependentClass : dependency.getValue().getEntities()) {
                TestMethodCall testName = dependency.getKey();
                this.addDependencies(testName, dependentClass);
            }
        }
    }

    private void addDependencies(TestMethodCall testName, MethodCall dependentClass) {
        Type dependencyEntity;
        Map<Type, Set<String>> testDependencies = this.dependencyMap.getOrAddDependenciesForTest(testName);
        Set<String> methods = testDependencies.get(dependencyEntity = new Type(dependentClass.getClazz(), dependentClass.getModule()));
        if (methods == null) {
            methods = new HashSet<String>();
            testDependencies.put(dependencyEntity, methods);
        }
        String method = dependentClass.getMethod() + dependentClass.getParameterString();
        methods.add(method);
    }

    private void checkCorrectness() {
        for (Map.Entry<TestMethodCall, CalledMethods> entry : this.dependencyMap.getDependencyMap().entrySet()) {
            if (entry.getKey().getModule() != null) continue;
            throw new RuntimeException("Entry " + String.valueOf(entry.getKey()) + " has null module!");
        }
    }
}

