/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.InitialCallList;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependency.traces.TraceFileMapping;
import de.dagere.peass.dependency.traces.TraceWriter;
import de.dagere.peass.folders.ResultsFolders;
import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OldTraceReader {
    private static final Logger LOG = LogManager.getLogger(OldTraceReader.class);
    private final TraceFileMapping traceFileMapping;
    private final StaticTestSelection dependencyResult;
    private final ResultsFolders resultsFolders;

    public OldTraceReader(TraceFileMapping traceFileMapping, StaticTestSelection dependencyResult, ResultsFolders resultsFolders) {
        this.traceFileMapping = traceFileMapping;
        this.dependencyResult = dependencyResult;
        this.resultsFolders = resultsFolders;
    }

    public void addTraces() {
        this.addInitialVersion();
        this.addRegularVersions();
        LOG.debug("Trace file finished reading");
    }

    private void addRegularVersions() {
        for (Map.Entry<String, CommitStaticSelection> commit : this.dependencyResult.getCommits().entrySet()) {
            TestSet tests = commit.getValue().getTests();
            for (TestMethodCall testcase : tests.getTestMethods()) {
                this.addPotentialTracefile(testcase, commit.getKey());
            }
        }
    }

    private void addInitialVersion() {
        for (Map.Entry<TestMethodCall, InitialCallList> classDependency : this.dependencyResult.getInitialcommit().getInitialDependencies().entrySet()) {
            TestMethodCall testcase = classDependency.getKey();
            String initialVersion = this.dependencyResult.getInitialcommit().getCommit();
            this.addPotentialTracefile(testcase, initialVersion);
        }
    }

    private void addPotentialTracefile(TestMethodCall testcase, String initialVersion) {
        String shortVersion = TraceWriter.getShortCommit(initialVersion);
        for (String ending : new String[]{"", ".txt", ".zip"}) {
            File potentialTraceFile = new File(this.resultsFolders.getViewMethodDir(initialVersion, testcase), shortVersion + ending);
            LOG.debug("Potential trace file: " + potentialTraceFile.getAbsolutePath() + " " + potentialTraceFile.exists());
            if (!potentialTraceFile.exists()) continue;
            this.traceFileMapping.addTraceFile(testcase, potentialTraceFile);
        }
    }
}

