/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.dependency.ExecutorCreator;
import de.dagere.peass.dependency.RTSTestTransformerBuilder;
import de.dagere.peass.dependency.reader.CommitKeeper;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.TestTransformer;
import de.dagere.peass.vcs.CommitIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunningCommitFinder {
    private static final Logger LOG = LogManager.getLogger(RunningCommitFinder.class);
    private final PeassFolders folders;
    private final CommitKeeper nonRunning;
    private final CommitIterator iterator;
    private final ExecutionConfig executionConfig;
    private final EnvironmentVariables env;

    public RunningCommitFinder(PeassFolders folders, CommitKeeper nonRunning, CommitIterator iterator, ExecutionConfig executionConfig, EnvironmentVariables env) {
        this.folders = folders;
        this.nonRunning = nonRunning;
        this.iterator = iterator;
        this.executionConfig = executionConfig;
        this.env = env;
    }

    public boolean searchFirstRunningCommit() {
        this.goToCommit(this.iterator);
        boolean isCommitRunning = false;
        TestTransformer transformer = RTSTestTransformerBuilder.createTestTransformer(this.folders, this.executionConfig, new KiekerConfig(false));
        while (!isCommitRunning && this.iterator.hasNextCommit()) {
            if (ExecutorCreator.hasBuildfile(this.folders, transformer)) {
                isCommitRunning = this.tryCommit(this.iterator, transformer);
                if (isCommitRunning) continue;
                this.iterator.goToNextCommit();
                continue;
            }
            this.nonRunning.addCommit(this.iterator.getCommitName(), "Buildfile does not exist.");
            this.iterator.goToNextCommit();
        }
        return isCommitRunning;
    }

    public boolean searchLatestRunningCommit() {
        TestTransformer transformer = RTSTestTransformerBuilder.createTestTransformer(this.folders, this.executionConfig, new KiekerConfig(false));
        boolean isCommitRunning = this.tryCommit(this.iterator, transformer);
        while (!isCommitRunning && this.iterator.hasPreviousCommit()) {
            this.iterator.goToPreviousCommit();
            this.nonRunning.addCommit(this.iterator.getCommitName(), "Buildfile does not exist.");
            if (!ExecutorCreator.hasBuildfile(this.folders, transformer)) continue;
            isCommitRunning = this.tryCommit(this.iterator, transformer);
        }
        return isCommitRunning;
    }

    private boolean tryCommit(CommitIterator iterator, TestTransformer testTransformer) {
        TestExecutor executor = ExecutorCreator.createExecutor(this.folders, testTransformer, this.env);
        boolean isCommitRunning = executor.isCommitRunning(iterator.getCommitName());
        if (!isCommitRunning) {
            LOG.debug("Buildfile does not exist / commit is not running {}", (Object)iterator.getCommitName());
            if (executor.doesBuildfileExist()) {
                this.nonRunning.addCommit(iterator.getCommitName(), "Commit is not running.");
            } else {
                this.nonRunning.addCommit(iterator.getCommitName(), "Buildfile does not exist.");
            }
        }
        return isCommitRunning;
    }

    public void goToCommit(CommitIterator iterator) {
        boolean successGettingCommit = iterator.goToFirstCommit();
        while (!successGettingCommit && iterator.hasNextCommit()) {
            successGettingCommit = iterator.goToNextCommit();
        }
        if (!successGettingCommit) {
            throw new RuntimeException("Repository does not contain usable commit - maybe path has changed?");
        }
        LOG.info("Found first commit: " + iterator.getCommitName());
    }

    public CommitKeeper getNonRunning() {
        return this.nonRunning;
    }
}

