/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.nodeDiffDetector.diffDetection.ClazzChangeData;
import de.dagere.peass.ci.NonIncludedByRule;
import de.dagere.peass.ci.NonIncludedTestRemover;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.DependencyManager;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.ChangeTestMapping;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.reader.DependencyReaderUtil;
import de.dagere.peass.dependency.reader.DependencyReadingInput;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.JUnitTestTransformer;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StaticChangeHandler {
    private static final Logger LOG = LogManager.getLogger(StaticChangeHandler.class);
    private final PeassFolders folders;
    private final ExecutionConfig executionConfig;
    private final DependencyManager dependencyManager;

    public StaticChangeHandler(PeassFolders folders, ExecutionConfig executionConfig, DependencyManager dependencyManager) {
        this.folders = folders;
        this.executionConfig = executionConfig;
        this.dependencyManager = dependencyManager;
    }

    public CommitStaticSelection handleStaticAnalysisChanges(String commit, DependencyReadingInput input, ModuleClassMapping mapping) throws IOException, JsonGenerationException, JsonMappingException {
        ChangeTestMapping changeTestMap = this.dependencyManager.getDependencyMap().getChangeTestMap(input.getChanges());
        LOG.debug("Change test mapping (without added tests): " + String.valueOf(changeTestMap));
        this.handleAddedTests(input, changeTestMap, mapping);
        if (this.executionConfig.isCreateDetailDebugFiles()) {
            Constants.OBJECTMAPPER.writeValue(new File(this.folders.getDebugFolder(), "changeTestMap_" + commit + ".json"), (Object)changeTestMap);
        }
        CommitStaticSelection newCommitStaticSelection = DependencyReaderUtil.createCommitFromChangeMap(input.getChanges(), changeTestMap);
        newCommitStaticSelection.setJdk(this.dependencyManager.getExecutor().getJDKVersion());
        newCommitStaticSelection.setPredecessor(input.getPredecessor());
        if (this.executionConfig.isCreateDetailDebugFiles()) {
            Constants.OBJECTMAPPER.writeValue(new File(this.folders.getDebugFolder(), "commitStaticSelection_" + commit + ".json"), (Object)newCommitStaticSelection);
        }
        return newCommitStaticSelection;
    }

    private void handleAddedTests(DependencyReadingInput input, ChangeTestMapping changeTestMap, ModuleClassMapping mapping) {
        this.dependencyManager.getTestTransformer().determineVersions(this.dependencyManager.getExecutor().getModules().getModules());
        for (ClazzChangeData changedEntry : input.getChanges().values()) {
            if (changedEntry.isOnlyMethodChange()) continue;
            for (Type change : changedEntry.getChanges()) {
                File moduleFolder = new File(this.folders.getProjectFolder(), change.getModule());
                TestClazzCall potentialTest = new TestClazzCall(change.getClazz(), change.getModule());
                Set<TestMethodCall> addedTests = this.dependencyManager.getTestTransformer().getTestMethodNames(moduleFolder, potentialTest);
                for (TestMethodCall added : addedTests) {
                    if (!NonIncludedTestRemover.isTestIncluded((TestCase)added, this.executionConfig)) continue;
                    if (this.dependencyManager.getTestTransformer() instanceof JUnitTestTransformer) {
                        JUnitTestTransformer testTransformer = (JUnitTestTransformer)this.dependencyManager.getTestTransformer();
                        if (NonIncludedByRule.isTestIncluded((TestCase)added, testTransformer, mapping)) {
                            changeTestMap.addChangeEntry(change, added);
                            continue;
                        }
                        LOG.info("Did not include added test {} because of included rules", (Object)added);
                        continue;
                    }
                    changeTestMap.addChangeEntry(change, added);
                }
            }
        }
    }
}

