/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.ci.NonIncludedByRule;
import de.dagere.peass.ci.NonIncludedTestRemover;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.dependency.DependencyManager;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestExistenceChanges;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.reader.DependencyReaderUtil;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.testtransformation.TestTransformer;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceChangeHandler {
    private static final boolean DETAIL_DEBUG = true;
    private static final Logger LOG = LogManager.getLogger(TraceChangeHandler.class);
    private final DependencyManager dependencyManager;
    private final PeassFolders folders;
    private final ExecutionConfig executionConfig;
    private final String commit;

    public TraceChangeHandler(DependencyManager dependencyManager, PeassFolders folders, ExecutionConfig executionConfig, String commit) {
        this.dependencyManager = dependencyManager;
        this.folders = folders;
        this.executionConfig = executionConfig;
        this.commit = commit;
    }

    public void handleTraceAnalysisChanges(CommitStaticSelection newCommitInfo) throws IOException {
        LOG.debug("Updating dependencies.. {}", (Object)this.commit);
        ModuleClassMapping mapping = new ModuleClassMapping(this.dependencyManager.getExecutor());
        TestSet testsToRun = this.getTestsToRun(newCommitInfo, mapping);
        if (testsToRun.classCount() > 0) {
            this.analyzeTests(newCommitInfo, testsToRun, mapping);
        }
    }

    private TestSet getTestsToRun(CommitStaticSelection newCommitStaticSelection, ModuleClassMapping mapping) throws IOException, JsonGenerationException, JsonMappingException {
        TestSet testsToRun = newCommitStaticSelection.getTests();
        this.addAddedTests(newCommitStaticSelection, testsToRun);
        Constants.OBJECTMAPPER.writeValue(new File(this.folders.getDebugFolder(), "toRun_" + this.commit + ".json"), testsToRun.entrySet());
        NonIncludedTestRemover.removeNotIncluded(testsToRun, this.executionConfig);
        TestTransformer testTransformer = this.dependencyManager.getTestTransformer();
        NonIncludedByRule.removeNotIncluded(testsToRun, testTransformer, mapping);
        return testsToRun;
    }

    public void addAddedTests(CommitStaticSelection newCommitInfo, TestSet testsToRun) {
        for (Type testName : newCommitInfo.getChangedClazzes().keySet()) {
            Type simplyClazz = testName.getSourceContainingClazz();
            TestClazzCall potentialTest = new TestClazzCall(simplyClazz.getClazz(), testName.getModule());
            if (!NonIncludedTestRemover.isTestClassIncluded(potentialTest, this.executionConfig)) continue;
            testsToRun.addTest(potentialTest, null);
        }
    }

    private void analyzeTests(CommitStaticSelection newCommitInfo, TestSet testsToRun, ModuleClassMapping mapping) throws IOException {
        this.dependencyManager.runTraceTests(testsToRun, this.commit);
        this.handleDependencyChanges(newCommitInfo, testsToRun, mapping);
        if (this.dependencyManager.getRunnableTestsInformation().getIgnoredTests().getTestMethods().size() > 0) {
            newCommitInfo.setIgnoredAffectedTests(this.dependencyManager.getRunnableTestsInformation().getIgnoredTests());
        }
        if (this.dependencyManager.getRunnableTestsInformation().getRemovedTests().getTestMethods().size() > 0) {
            newCommitInfo.setRemovedTests(this.dependencyManager.getRunnableTestsInformation().getRemovedTests());
        }
    }

    private void handleDependencyChanges(CommitStaticSelection newVersionStaticSelection, TestSet testsToRun, ModuleClassMapping mapping) throws IOException {
        TestExistenceChanges testExistenceChanges = this.dependencyManager.updateDependencies(testsToRun, mapping);
        Map<Type, Set<TestMethodCall>> addedTestcases = testExistenceChanges.getAddedTests();
        Constants.OBJECTMAPPER.writeValue(new File(this.folders.getDebugFolder(), "add_" + this.commit + ".json"), addedTestcases);
        Constants.OBJECTMAPPER.writeValue(new File(this.folders.getDebugFolder(), "remove_" + this.commit + ".json"), testExistenceChanges.getRemovedTests());
        DependencyReaderUtil.removeDeletedTestcases(newVersionStaticSelection, testExistenceChanges);
        DependencyReaderUtil.addNewTestcases(newVersionStaticSelection, addedTestcases);
        Constants.OBJECTMAPPER.writeValue(new File(this.folders.getDebugFolder(), "finalStaticSelection_" + this.commit + ".json"), (Object)newVersionStaticSelection);
    }
}

