/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader;

import com.github.javaparser.ParseException;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.TestSelectionConfig;
import de.dagere.peass.dependency.DependencyManager;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.traces.OneTraceGenerator;
import de.dagere.peass.dependency.traces.TraceFileMapping;
import de.dagere.peass.execution.utils.ProjectModules;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceViewGenerator {
    private static final Logger LOG = LogManager.getLogger(TraceViewGenerator.class);
    private final DependencyManager dependencyManager;
    private final PeassFolders folders;
    private final String commit;
    private final TraceFileMapping traceFileMapping;
    private final KiekerConfig kiekerConfig;
    private final TestSelectionConfig testSelectionConfig;

    public TraceViewGenerator(DependencyManager dependencyManager, PeassFolders folders, String version, TraceFileMapping mapping, KiekerConfig kiekerConfig, TestSelectionConfig testSelectionConfig) {
        this.dependencyManager = dependencyManager;
        this.folders = folders;
        this.commit = version;
        this.traceFileMapping = mapping;
        this.kiekerConfig = kiekerConfig;
        this.testSelectionConfig = testSelectionConfig;
    }

    public void generateViews(ResultsFolders resultsFolders, TestSet examinedTests) throws IOException, ParseException {
        LOG.debug("Generating views for {}", (Object)this.commit);
        GitUtils.reset(this.folders.getProjectFolder());
        ProjectModules modules = this.dependencyManager.getExecutor().getModules();
        ModuleClassMapping mapping = new ModuleClassMapping(this.dependencyManager.getExecutor());
        List<File> classpathFolders = this.getClasspathFolders(modules);
        for (TestClazzCall clazzCall : examinedTests.getTestClazzes()) {
            LOG.debug("Test clazz {} did not contain tests and therefore is not analyzed further", (Object)clazzCall);
        }
        for (TestMethodCall testcase : examinedTests.getTestMethods()) {
            OneTraceGenerator oneViewGenerator = new OneTraceGenerator(resultsFolders, this.folders, testcase, this.traceFileMapping, this.commit, classpathFolders, mapping, this.kiekerConfig, this.testSelectionConfig);
            oneViewGenerator.generateTrace(this.commit);
        }
    }

    private List<File> getClasspathFolders(ProjectModules modules) {
        ExecutionConfig executionConfig = this.dependencyManager.getTestTransformer().getConfig().getExecutionConfig();
        LinkedList<File> files = new LinkedList<File>();
        for (int i = 0; i < modules.getModules().size(); ++i) {
            File module = modules.getModules().get(i);
            for (String clazzPath : executionConfig.getClazzFolders()) {
                files.add(new File(module, clazzPath));
            }
            for (String testClazzPath : executionConfig.getTestClazzFolders()) {
                files.add(new File(module, testClazzPath));
            }
        }
        return files;
    }
}

