/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.reader.twiceExecution;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TwiceExecutableChecker {
    private static final Logger LOG = LogManager.getLogger(TwiceExecutableChecker.class);
    private final TestExecutor executor;
    private final TestTransformer transformer;
    private final ExecutionData executionData;

    public TwiceExecutableChecker(TestExecutor executor, ExecutionData executionData) {
        this.executor = executor;
        this.transformer = executor.getTestTransformer();
        this.executionData = executionData;
    }

    public void checkTwiceExecution(String commit, String predecessor, Set<TestMethodCall> tests) {
        this.transformer.getConfig().setIterations(2);
        this.executionData.addEmptyCommit(commit, predecessor);
        File twiceRunningLogFolder = new File(this.executor.getFolders().getTwiceRunningLogFolder(), commit);
        twiceRunningLogFolder.mkdir();
        this.executor.prepareKoPeMeExecution(new File(twiceRunningLogFolder, "twicePreparation.txt"));
        this.truncateLastRunResults();
        for (TestMethodCall testcase : tests) {
            this.executor.executeTest(testcase, twiceRunningLogFolder, this.transformer.getConfig().getExecutionConfig().getTimeout());
            this.checkTestExistance(commit, testcase);
        }
    }

    private void truncateLastRunResults() {
        try {
            FileUtils.deleteDirectory((File)this.executor.getFolders().getTempMeasurementFolder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkTestExistance(String commit, TestMethodCall testcase) {
        List<File> folderCandidates = this.executor.getFolders().findTempClazzFolder((TestCase)testcase);
        if (!folderCandidates.isEmpty()) {
            String methodname;
            File folder = (File)folderCandidates.iterator().next();
            File oneResultFile = new File(folder, (methodname = testcase.getMethodWithParams()) + ".json");
            Kopemedata data = JSONDataLoader.loadData((File)oneResultFile);
            List firstDataCollectorContent = data.getFirstDatacollectorContent();
            if (firstDataCollectorContent.size() == 1 && !((VMResult)firstDataCollectorContent.get(0)).isError()) {
                LOG.info("Test is twice executable and therefore likely to be suitable for performance measurement: {}", (Object)testcase);
                this.executionData.addCall(commit, testcase);
            } else {
                LOG.info("Test is *not* twice executable and therefore likely to be *not* suitable for performance measurement: {}", (Object)testcase);
            }
        } else {
            LOG.info("Test is *not* twice executable and therefore likely to be *not* suitable for performance measurement: {}", (Object)testcase);
        }
    }
}

