/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.statistics;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.data.Type;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependency.statistics.DependencyStatistics;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

public class DependencyStatisticAnalyzer
implements Callable<Void> {
    private static final Logger LOG = LogManager.getLogger(DependencyStatisticAnalyzer.class);
    @CommandLine.Option(names={"-startversion", "--startversion"}, description={"startversion"})
    String startversion;
    @CommandLine.Option(names={"-endversion", "--endversion"}, description={"endversion"})
    String endversion;
    @CommandLine.Option(names={"-dependencyFile", "--dependencyFile"}, description={"Dependencyfile"}, required=true)
    File dependencyFile;
    @CommandLine.Option(names={"-executionFile", "--executionFile"}, description={"executionFile"})
    File executionFile;

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        CommandLine commandLine = new CommandLine((Object)new DependencyStatisticAnalyzer());
        commandLine.execute(args);
    }

    @Override
    public Void call() throws Exception {
        if (!this.dependencyFile.exists()) {
            LOG.info("Dependencies-file " + this.dependencyFile.getAbsolutePath() + " should exist.");
            System.exit(1);
        }
        ExecutionData changedTests = this.executionFile != null ? (ExecutionData)Constants.OBJECTMAPPER.readValue(this.executionFile, ExecutionData.class) : null;
        DependencyStatistics statistics = DependencyStatisticAnalyzer.getChangeStatistics(this.dependencyFile, changedTests);
        LOG.info("Versions: {} Bei Pruning ausgef\u00fchrte Tests: {} Trace-Changed Tests: {}", (Object)statistics.size, (Object)statistics.pruningRunTests, (Object)statistics.changedTraceTests);
        LOG.info("Gesamt-Tests: {} Bei Pruning (ggf. mehrmals) genutzte Tests: {} Nur einmal ausgef\u00fchrte Tests (d.h. keine Ver\u00e4nderung m\u00f6glich): {}", (Object)statistics.overallRunTests, (Object)statistics.multipleChangedTest.size(), (Object)statistics.onceChangedTests.size());
        return null;
    }

    public static DependencyStatistics getChangeStatistics(File dependenciesFile, ExecutionData changedTests) throws JsonParseException, JsonMappingException, IOException {
        StaticTestSelection dependencies = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(dependenciesFile, StaticTestSelection.class);
        Map<String, CommitStaticSelection> versions = dependencies.getCommits();
        int startTestCound = dependencies.getInitialcommit().getInitialDependencies().size();
        LinkedList<TestMethodCall> currentContainedTests = new LinkedList<TestMethodCall>();
        for (TestMethodCall dependency : dependencies.getInitialcommit().getInitialDependencies().keySet()) {
            currentContainedTests.add(dependency);
        }
        LOG.trace("StartTest: {}", (Object)startTestCound);
        DependencyStatistics statistics = new DependencyStatistics();
        statistics.onceChangedTests.addAll(currentContainedTests);
        statistics.size = versions.size();
        for (Map.Entry<String, CommitStaticSelection> version : versions.entrySet()) {
            HashSet<TestMethodCall> currentIterationTests = new HashSet<TestMethodCall>();
            for (Map.Entry<Type, TestSet> dependency : version.getValue().getChangedClazzes().entrySet()) {
                for (Map.Entry<TestClazzCall, Set<String>> testcase : dependency.getValue().getTestcases().entrySet()) {
                    String testclass = testcase.getKey().getClazz();
                    for (String method : testcase.getValue()) {
                        TestMethodCall testcase2 = new TestMethodCall(testclass, method);
                        if (currentContainedTests.contains(testcase2)) {
                            currentIterationTests.add(testcase2);
                            continue;
                        }
                        currentContainedTests.add(testcase2);
                        statistics.onceChangedTests.add((TestCase)testcase2);
                    }
                }
            }
            int currentTraceChangedTests = 0;
            if (changedTests != null) {
                for (TestMethodCall currentIterationTest : currentContainedTests) {
                    if (!changedTests.commitContainsTest(version.getKey(), currentIterationTest)) continue;
                    ++currentTraceChangedTests;
                }
            }
            LOG.trace("Version: {} Tests: {} Trace-Changed: {}", (Object)version.getKey(), (Object)currentIterationTests.size(), (Object)currentTraceChangedTests);
            statistics.multipleChangedTest.addAll(currentIterationTests);
            statistics.onceChangedTests.removeAll(currentIterationTests);
            statistics.changedTraceTests += currentTraceChangedTests;
            statistics.pruningRunTests += currentIterationTests.size();
            statistics.overallRunTests += currentContainedTests.size();
        }
        return statistics;
    }
}

