/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ErrorLogWriter {
    private static final Logger LOG = LogManager.getLogger(ErrorLogWriter.class);
    private final TestMethodCall testcase;
    private final File resultsFolder;

    public ErrorLogWriter(TestMethodCall testcase, File resultsFolder) {
        this.testcase = testcase;
        this.resultsFolder = resultsFolder;
    }

    public void tryToWriteLastLog() {
        File logFolder = new File(this.resultsFolder, "../../logs/");
        LOG.info("Searching in" + logFolder.getAbsolutePath());
        if (logFolder.exists()) {
            this.writeLogFolderContent(logFolder);
        } else {
            File testingFolder = new File(this.resultsFolder, "../");
            for (int index = 0; !testingFolder.exists() && index < 10; ++index) {
                LOG.info("Folder " + testingFolder.getAbsolutePath() + " did not exist");
                testingFolder = new File(testingFolder.getAbsolutePath(), "..");
            }
            if (testingFolder.exists()) {
                LOG.info("Files in " + testingFolder.getAbsolutePath());
                for (File file : testingFolder.listFiles()) {
                    System.out.println(file.getAbsolutePath());
                }
            } else {
                LOG.info("Did no succeed searching in parent folders; start to search from root");
                String[] parts = this.resultsFolder.getAbsolutePath().split(File.separator);
                File userFolder = new File(File.separator + parts[0] + File.separator + parts[1]);
                System.out.println(userFolder.getAbsolutePath() + " " + userFolder.exists());
                for (int i = 2; i < parts.length; ++i) {
                    userFolder = new File(userFolder, parts[i]);
                    System.out.println(userFolder.getAbsolutePath() + " " + userFolder.exists());
                    if (!userFolder.getName().endsWith("_peass")) continue;
                    File foundLogFolder = new File(userFolder, "logs");
                    if (foundLogFolder.exists()) {
                        this.writeLogFolderContent(foundLogFolder);
                        continue;
                    }
                    LOG.info("Expected log folder {} did not exist", (Object)foundLogFolder);
                }
            }
        }
    }

    private void writeLogFolderContent(File logFolder) {
        File[] logFiles = logFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (logFiles != null && logFiles.length > 0) {
            File logFolderChild = logFiles[0];
            LOG.info("First folder: " + logFolderChild.getAbsolutePath());
            File txtFile = new File(logFolderChild, "log_" + this.testcase.getClazz() + "/" + this.testcase.getMethod() + ".txt");
            LOG.info("Trying " + txtFile.getAbsolutePath() + " " + txtFile.exists());
            if (txtFile.exists()) {
                try {
                    System.out.println(FileUtils.readFileToString((File)txtFile, (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            LOG.info("Logfolder was empty");
        }
    }
}

