/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependency.KiekerResultManager;
import de.dagere.peass.dependency.traces.ErrorLogWriter;
import de.dagere.peass.folders.PeassFolders;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KiekerFolderUtil {
    private static final Logger LOG = LogManager.getLogger(KiekerFolderUtil.class);

    public static File[] getClazzMethodFolder(TestMethodCall testcase, File resultsFolder) {
        File testclazzResultFolder = new File(resultsFolder, testcase.getClazz());
        Object[] kiekerTimestampFolders = testclazzResultFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().matches("[0-9]*");
            }
        });
        if (kiekerTimestampFolders == null) {
            new ErrorLogWriter(testcase, resultsFolder).tryToWriteLastLog();
            LOG.debug("Probably project not running - Result folder: " + Arrays.toString(kiekerTimestampFolders) + " (" + String.valueOf(kiekerTimestampFolders != null ? Integer.valueOf(kiekerTimestampFolders.length) : "null") + ") in " + testclazzResultFolder.getAbsolutePath() + " should exist!");
            return null;
        }
        File methodResult = KiekerFolderUtil.getMethodFolder(testcase, (File[])kiekerTimestampFolders);
        LOG.debug("Searching in: {}", (Object)methodResult);
        if (methodResult.exists() && methodResult.isDirectory()) {
            if (methodResult.listFiles().length > 0) {
                return methodResult.listFiles();
            }
            throw new RuntimeException("Folder " + String.valueOf(methodResult) + " is no Kieker result folder; folder is empty!");
        }
        throw new RuntimeException("Folder " + String.valueOf(methodResult) + " is no Kieker result folder; does not exist or is no directory!");
    }

    public static File getKiekerTraceFolder(File kiekerResultFolder, TestMethodCall testcase) {
        File methodResult = new File(kiekerResultFolder, testcase.getMethodWithParams());
        LOG.debug("Searching in: {}", (Object)methodResult);
        if (methodResult.exists() && methodResult.isDirectory()) {
            if (methodResult.listFiles().length > 0) {
                return methodResult.listFiles()[0];
            }
            throw new RuntimeException("Folder " + String.valueOf(methodResult) + " is no Kieker result folder!");
        }
        throw new RuntimeException("Folder " + String.valueOf(methodResult) + " is no Kieker result folder!");
    }

    private static File getMethodFolder(TestMethodCall testcase, File[] kiekerTimestampFolders) {
        String methodName = testcase.getMethodWithParams();
        File methodResult = new File(kiekerTimestampFolders[0], methodName);
        for (File test : kiekerTimestampFolders) {
            File candidate = new File(test, methodName);
            if (!candidate.exists()) continue;
            methodResult = candidate;
        }
        return methodResult;
    }

    public static File getModuleResultFolder(PeassFolders folders, TestCase testcase) {
        File rawModuleFolder;
        File moduleResultsFolder;
        if (testcase.getModule() != null && (moduleResultsFolder = KiekerResultManager.getJSONFileFolder(folders, rawModuleFolder = new File(folders.getProjectFolder(), testcase.getModule()))).exists()) {
            return moduleResultsFolder;
        }
        File projectResultsFolder = KiekerResultManager.getJSONFileFolder(folders, folders.getProjectFolder());
        return projectResultsFolder;
    }
}

