/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.KiekerConfig;
import de.dagere.peass.config.TestSelectionConfig;
import de.dagere.peass.dependency.analysis.CalledMethodLoader;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TraceElement;
import de.dagere.peass.dependency.traces.KiekerFolderUtil;
import de.dagere.peass.dependency.traces.TraceFileMapping;
import de.dagere.peass.dependency.traces.TraceMethodReader;
import de.dagere.peass.dependency.traces.TraceWithMethods;
import de.dagere.peass.dependency.traces.TraceWriter;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OneTraceGenerator {
    public static final String METHOD = "_method";
    public static final String METHOD_EXPANDED = "_method_expanded";
    public static final String NOCOMMENT = "_nocomment";
    public static final String SUMMARY = "_summary";
    private static final Logger LOG = LogManager.getLogger(OneTraceGenerator.class);
    private final PeassFolders folders;
    private final TestMethodCall testcase;
    private final TraceFileMapping traceFileMapping;
    private final String commit;
    private final ResultsFolders resultsFolders;
    private final List<File> classpathFolders;
    private final ModuleClassMapping moduleClassMapping;
    private final KiekerConfig kiekerConfig;
    private final TestSelectionConfig testSelectionConfig;

    public OneTraceGenerator(ResultsFolders resultsFolders, PeassFolders folders, TestMethodCall testcase, TraceFileMapping traceFileMapping, String commit, List<File> classpathFolders, ModuleClassMapping mapping, KiekerConfig kiekerConfig, TestSelectionConfig testSelectionConfig) {
        this.resultsFolders = resultsFolders;
        this.folders = folders;
        this.testcase = testcase;
        this.traceFileMapping = traceFileMapping;
        this.commit = commit;
        this.classpathFolders = classpathFolders;
        this.moduleClassMapping = mapping;
        this.kiekerConfig = kiekerConfig;
        this.testSelectionConfig = testSelectionConfig;
    }

    public void generateTrace(String commitCurrent) {
        try {
            File moduleResultsFolder = KiekerFolderUtil.getModuleResultFolder(this.folders, (TestCase)this.testcase);
            File[] kiekerResultFolders = KiekerFolderUtil.getClazzMethodFolder(this.testcase, moduleResultsFolder);
            File testclazzResultFolder = new File(moduleResultsFolder, this.testcase.getClazz());
            File methodJSON = new File(testclazzResultFolder, this.testcase.getMethodWithParams() + ".json");
            Kopemedata data = (Kopemedata)Constants.OBJECTMAPPER.readValue(methodJSON, Kopemedata.class);
            if (data.getFirstResult().isError()) {
                LOG.error("Testcase {} contained an error; not creating trace", (Object)this.testcase);
            } else {
                LOG.debug("Searching for: {}", (Object)kiekerResultFolders[0]);
                if (kiekerResultFolders[0].exists() && kiekerResultFolders[0].isDirectory()) {
                    this.generateTraceFiles(commitCurrent, kiekerResultFolders);
                } else {
                    LOG.error("Error: {} does not produce {}", (Object)commitCurrent, (Object)kiekerResultFolders[0].getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateTraceFiles(String commitCurrent, File[] kiekerResultFolders) throws FileNotFoundException, IOException {
        boolean success = false;
        TraceWithMethods trace = null;
        TraceMethodReader traceMethodReader = null;
        int overallSizeInMb = 0;
        for (File kiekerResultFolder : kiekerResultFolders) {
            long size = FileUtils.sizeOfDirectory((File)kiekerResultFolder);
            long sizeInMB = size / 0x100000L;
            overallSizeInMb = (int)((long)overallSizeInMb + sizeInMB);
            LOG.debug("Filesize: {} ({})", (Object)sizeInMB, (Object)size);
            if (sizeInMB < this.kiekerConfig.getTraceSizeInMb()) {
                CalledMethodLoader calledMethodLoader = new CalledMethodLoader(kiekerResultFolder, this.moduleClassMapping, this.kiekerConfig);
                ArrayList<TraceElement> shortTrace = calledMethodLoader.getShortTrace("");
                if (shortTrace == null) continue;
                LOG.debug("Short Trace: {} Folder: {} Project: {}", (Object)shortTrace.size(), (Object)kiekerResultFolder.getAbsolutePath(), (Object)this.folders.getProjectFolder());
                if (shortTrace.size() > 0) {
                    traceMethodReader = new TraceMethodReader(shortTrace, this.classpathFolders.toArray(new File[0]));
                    if (trace == null) {
                        trace = traceMethodReader.getTraceWithMethods();
                    } else {
                        TraceWithMethods additionalTrace = traceMethodReader.getTraceWithMethods();
                        trace.append(additionalTrace);
                    }
                    success = true;
                    continue;
                }
                LOG.warn("Trace is empty! (Which is ok for first execution of a parameterized test.)");
                continue;
            }
            LOG.error("File size exceeds {} MB", (Object)this.kiekerConfig.getTraceSizeInMb());
            FileUtils.deleteDirectory((File)kiekerResultFolder);
        }
        if (success) {
            this.writeTrace(commitCurrent, overallSizeInMb, traceMethodReader, trace);
        }
    }

    private void writeTrace(String versionCurrent, long sizeInMB, TraceMethodReader traceMethodReader, TraceWithMethods trace) throws IOException {
        TraceWriter traceWriter = new TraceWriter(this.commit, this.testcase, this.resultsFolders, this.traceFileMapping, this.testSelectionConfig);
        traceWriter.writeTrace(versionCurrent, sizeInMB, traceMethodReader, trace);
    }
}

