/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.TempPeassFolders;
import de.dagere.peass.folders.VMExecutionLogFolders;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemporaryProjectFolderUtil {
    private static final Logger LOG = LogManager.getLogger(TemporaryProjectFolderUtil.class);

    public static PeassFolders cloneForcefully(PeassFolders originalFolders, File dest, VMExecutionLogFolders logFolders, String gitCryptKey) {
        try {
            if (dest.exists()) {
                LOG.warn("Deleting existing folder {}", (Object)dest);
                FileUtils.deleteDirectory((File)dest);
                File peassFolder = new File(dest.getParentFile(), dest.getName() + "_peass");
                if (peassFolder.exists()) {
                    FileUtils.deleteDirectory((File)peassFolder);
                }
            }
            GitUtils.clone(originalFolders, dest, gitCryptKey);
            TempPeassFolders folders = new TempPeassFolders(dest, originalFolders.getProjectName(), logFolders);
            return folders;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

