/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.dependency.traces;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.MethodCallHelper;
import de.dagere.peass.dependency.analysis.data.TraceElement;
import de.dagere.requitur.content.Content;
import java.util.Arrays;
import java.util.List;

public class TraceElementContent
extends Content {
    private final String module;
    private final String clazz;
    private final String method;
    private final boolean isStatic;
    private final String[] parameterTypes;
    private final int depth;

    public TraceElementContent(TraceElement element) {
        this.clazz = element.getClazz();
        this.method = element.getMethod();
        this.module = element.getModule();
        this.parameterTypes = element.getParameterTypes();
        this.depth = element.getDepth();
        this.isStatic = element.isStatic();
    }

    public TraceElementContent(String clazz, String method, String[] parameterTypes, int depth) {
        this.clazz = clazz;
        this.method = method;
        if (method.contains("(") || method.contains(")")) {
            throw new RuntimeException("Method should not included paranthesis, since it is only the method name without parameters");
        }
        this.module = null;
        this.depth = depth;
        this.parameterTypes = parameterTypes;
        this.isStatic = false;
    }

    public TraceElementContent(String clazz, String method, String module, String[] parameterTypes, int depth) {
        this.clazz = clazz;
        this.method = method;
        this.module = module;
        this.depth = depth;
        this.parameterTypes = parameterTypes;
        this.isStatic = false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TraceElementContent) {
            TraceElementContent other = (TraceElementContent)((Object)obj);
            if (this.module == null && other.module == null) {
                return other.getClazz().equals(this.getClazz()) && other.getMethod().equals(this.getMethod()) && Arrays.equals(other.getParameterTypes(), this.getParameterTypes());
            }
            if (this.module == null != (other.module == null)) {
                return false;
            }
            return other.getModule().equals(this.getModule()) && other.getClazz().equals(this.getClazz()) && other.getMethod().equals(this.getMethod()) && Arrays.equals(other.getParameterTypes(), this.getParameterTypes());
        }
        return false;
    }

    public int hashCode() {
        return this.clazz.hashCode() + this.method.hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.module != null && !this.module.equals("")) {
            result.append(this.module);
            result.append("\u00a7");
        }
        result.append(this.clazz);
        result.append("#");
        result.append(this.method);
        if (this.parameterTypes.length != 0) {
            result.append(MethodCallHelper.getParameterString((String[])this.parameterTypes));
        }
        return result.toString();
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getMethod() {
        return this.method;
    }

    public String getModule() {
        return this.module;
    }

    public String getPackagelessClazz() {
        String simpleClazz = this.clazz.substring(this.clazz.lastIndexOf(46) + 1);
        return simpleClazz;
    }

    public String getSimpleClazz() {
        if (this.clazz.contains("$")) {
            return this.clazz.substring(this.clazz.lastIndexOf("$") + 1);
        }
        String simpleClazz = this.clazz.substring(this.clazz.lastIndexOf(46) + 1);
        return simpleClazz;
    }

    public int getDepth() {
        return this.depth;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean isInnerClassCall() {
        return this.clazz.contains("$");
    }

    public String getOuterClass() {
        return this.clazz.substring(0, this.clazz.lastIndexOf("$"));
    }

    public String getPackage() {
        String result = this.clazz.contains(".") ? this.clazz.substring(0, this.clazz.lastIndexOf(46)) : "";
        return result;
    }

    public MethodCall toEntity() {
        MethodCall changedEntity = new MethodCall(this.clazz, this.module, this.method);
        List<String> parameterTypeList = Arrays.asList(this.parameterTypes);
        changedEntity.getParameters().addAll(parameterTypeList);
        return changedEntity;
    }
}

